/*
 * Created on 2004/09/22
 */
package nethome.text;

import jp.kitec.kwt.KColor;
import jp.kitec.lib.util.tree.ObjectFolder;


/**
 * @author kawae
 * @since 2004/09/22
 */
public interface ITextFormat {
	/**
	 * フォーマットの設定
	 * @param f
	 * @author kawae
	 * @since 2004/09/22
	 */
	public void setFormat(ITextFormat f);

	/**
	 * フォント名の設定
	 * @param s
	 * @author kawae
	 * @since 2004/09/22
	 */
	public void setFontName(String s);

	/**
	 * フォント名の取得
	 * @return
	 * @author kawae
	 * @since 2004/09/22
	 */
	public String getFontName();

	/**
	 * フォントスタイルの設定
	 *
	 * @author kawae
	 * @since 2004/09/22
	 */
	public void setFontStyle(int style);

	/**
	 * フォントスタイルの取得
	 * @return
	 * @author kawae
	 * @since 2004/09/22
	 */
	public int getFontStyle();

	/**
	 * フォントサイズの設定
	 * @param f
	 * @author kawae
	 * @since 2004/09/22
	 */
	public void setFontSize(double f);

	/**
	 * フォントサイズの取得
	 * @return
	 * @author kawae
	 * @since 2004/09/22
	 */
	public double getFontSize();

	/**
	 * アンダーラインの設定
	 * @param flag
	 * @return
	 * @author kawae
	 * @since 2004/09/22
	 */
	public void setUnderLine(boolean flag);

	/**
	 * アンダーラインの取得
	 * @return
	 * @author kawae
	 * @since 2004/09/22
	 */
	public boolean isUnderLine();

	/**
	 * テキスト色の設定
	 * @param c
	 * @author kawae
	 * @since 2004/09/22
	 */
	public void setTextColor(KColor c);

	/**
	 * テキスト色の取得
	 * @return
	 * @author kawae
	 * @since 2004/09/22
	 */
	public KColor getTextColor();

	/**
	 * 塗りつぶし色の設定
	 * @param c
	 * @author kawae
	 * @since 2004/09/22
	 */
	public void setBackColor(KColor c);

	/**
	 * 塗りつぶし色の取得
	 * @return
	 * @author kawae
	 * @since 2004/09/22
	 */
	public KColor getBackColor();

	/**
	 * 同じフォーマットか確認
	 * @param tf
	 * @return
	 * @author kawae
	 * @since 2004/09/26
	 */
	public boolean isSameTextFormat(ITextFormat tf);


	public void save(ObjectFolder savenode);
}
