package nethome.ui;

import java.util.HashMap;
import java.util.Map;

import jp.kitec.lib.io.FileSystem;
import nethome.lib.ObjectLibrary;

public abstract class AbstractNethomeRuntime implements INethomeRuntime {
	/** ライブラリ */
	private Map<String, ObjectLibrary> mLibrary;

	/** 標準のファイルシステム */
	protected FileSystem mFileSystem;

	protected AbstractNethomeRuntime() {
		mLibrary = new HashMap<String, ObjectLibrary>();
	}

	/**
	 * ユーザファイルシステムの設定
	 */
	@Override
	public void setFileSystem(FileSystem fs) {
		mFileSystem = fs;
	}

	/**
	 * ユーザファイルシステムの取得
	 * @return
	 */
	@Override
	public FileSystem getFileSystem() {
		return mFileSystem;
	}

	/**
	 * ライブラリの登録
	 * @param key
	 * @param lib
	 */
	@Override
	public void registerLibrary(String key, ObjectLibrary lib) {
		if (key != null && lib != null)
			mLibrary.put(key, lib);
	}

	/**
	 * ライブラリの取得
	 * @param key
	 * @return
	 */
	@Override
	public ObjectLibrary getLibrary(String key) {
		Object o = mLibrary.get(key);
		if (o != null && o instanceof ObjectLibrary) {
			return (ObjectLibrary)o;
		}
		return null;
	}
}
