package nethome.geom.util;

import java.util.Vector;

import nethome.geom.primitive.GPoint2Df;

/**
 * <p>タイトル: 凸包計算クラス</p>
 * <p>説明: </p>
 * <p>著作権: Copyright (c) 2002</p>
 * <p>会社名: </p>
 * @author 未入力
 * @version 1.0
 */

public class TotsuHou {

	/**
	 * コンストラクタ
	 */
	public TotsuHou() {
	}

	/**
	 * 凸包の計算。
	 * pointsに対して破壊的操作が行われるので注意。
	 * @param points
	 * @return
	 */
	public static Vector<GPoint2Df> getTotshuhou (Vector<? extends GPoint2Df> points) {
		if (points.size() < 3)
			return null;
		selectMin(points);
		sortPoints(points);

		int stk[] = new int[points.size()];
		int top = 2;
		stk[0] = 0;
		stk[1] = 1;
		stk[2] = 2;
		for (int i = 3; i < points.size(); i++) {
			GPoint2Df p2 = points.elementAt(i);
			while (true) {
				GPoint2Df p0 = points.elementAt(stk[top-1]);
				GPoint2Df p1 = points.elementAt(stk[top]);
				if (ToolMath.crossProduct(p0.x, p0.y, p1.x, p1.y, p2.x, p2.y) >= 0)
					break;
				top--;
			}
			stk[++top] = i;
		}

		Vector<GPoint2Df> res = new Vector<GPoint2Df>();
		for (int i = 0; i <= top; i++) {
			GPoint2Df p = points.elementAt(stk[i]);
			res.addElement(new GPoint2Df(p.x, p.y));
		}
		return res;
	}


	/**
	 * 点のスワップ
	 */
	private static void swapPoints (GPoint2Df p1, GPoint2Df p2) {
		double x, y;
		x = p1.x;
		y = p1.y;
		p1.x = p2.x;
		p1.y = p2.y;
		p2.x = x;
		p2.y = y;
	}

	/**
	 * 最小のものの選択
	 */
	private static void selectMin (Vector<? extends GPoint2Df> points) {
		double ym = ((GPoint2Df)points.elementAt(0)).y;
		int m = 0;
		for (int i = 1; i < points.size(); i++) {
			GPoint2Df p = points.elementAt(i);
			GPoint2Df pm = points.elementAt(m);
			if (ym > p.y || (Math.abs(ym - p.y) < ToolMath.EPS && pm.x > p.x)) {
				ym = p.y;
				m = i;
			}
		}
		swapPoints(points.elementAt(0), points.elementAt(m));
	}

	/**
	 * 点のソート
	 */
	private static void sortPoints (Vector<? extends GPoint2Df> points) {
		for (int i = 1; i < points.size() - 1; i++) {
			for (int j = i + 1; j < points.size(); j++) {
				GPoint2Df p0 = points.elementAt(0);
				GPoint2Df pi = points.elementAt(i);
				GPoint2Df pj = points.elementAt(j);
				if (ToolMath.crossProduct(p0.x, p0.y, pi.x, pi.y, pj.x, pj.y) < 0)
					swapPoints(pi, pj);
			}
		}
	}
}
