package nethome.geom.util;

import javax.vecmath.Point2d;

import nethome.geom.primitive.GCircle;

/**
 * 幾何計算クラス
 */
public class ToolMathVec extends ToolMath {
//	public static double EPS  = 1.0e-3f;

	/**
	 * 内積を求める
	 */
//	public static double getNaiseki (double p0x, double p0y, double p1x, double p1y, double p2x, double p2y) {
//		double dx1 = p1x - p0x, dy1 = p1y - p0y;
//		double dx2 = p2x - p0x, dy2 = p2y - p0y;
//		return dx1 * dy2 - dx2 * dy1;
//	}

	/**
	 * 2直線の角度の取得（時計回り方向）
	 * @param ax1
	 * @param ay1
	 * @param ax2
	 * @param ay2
	 * @param bx1
	 * @param by1
	 * @param bx2
	 * @param by2
	 * @return
	 */
	public static double getAngle2Lines(Point2d p1, Point2d p2, Point2d p3) {
		return getAngle2Lines(p1.x, p1.y, p2.x, p2.y, p3.x, p3.y);
	}

	/**
	 * ２Dでの角度の計算
	 * @param x1 点１のX座標
	 * @param y1 点１のY座標
	 * @param x2 点２のX座標
	 * @param y2 点２のY座標
	 */
	public static double getAngle2D (Point2d p1, Point2d p2) {
		return getAngle2D(p1.x, p1.y, p2.x, p2.y);
	}
/*
	private static void getDevide(Geometry g1, Geometry g2) {
		double res[] = new double[2];

		//両方直線
		if (g1 instanceof GLine && g2 instanceof GLine) {
			Point2d pa1 = ((GLine)g1).mPa;
			Point2d pa2 = ((GLine)g1).mPb;
			Point2d pb1 = ((GLine)g2).mPa;
			Point2d pb2 = ((GLine)g2).mPb;
			if (ToolMath.isCrossSegment(pa1.x, pa1.y, pa2.x, pa2.y, pb1.x, pb1.y, pb2.x, pb2.y, res)) {
				if (!ToolMath.isSame2D(pa1.x, pa1.y, res[0], res[1]) && !ToolMath.isSame2D(pa2.x, pa2.y, res[0], res[1]))
					a.insertElementAt(new LinkedPoint2Df(res[0], res[1]), ita);
				if (!ToolMath.isSame2D(pb1.x, pb1.y, res[0], res[1]) && !ToolMath.isSame2D(pb2.x, pb2.y, res[0], res[1]))
					b.insertElementAt(new LinkedPoint2Df(res[0], res[1]), itb);
			}
		//a側にのみサークル存在
		} else if (pa1.mFlagObj != null && pb1.mFlagObj == null) {
			GCircle c = (GCircle)pa1.mFlagObj;
			Point2d[] pts = ToolMathEx.isCrossArcAndLine(pb1, pb2, c);
			if (pts != null) {
				Point2d p;
				ToolMathEx.getSort(pts, c);
				for (int i = 0; i < 2; i++) {
					if ((p = pts[i]) != null) {
						if (!ToolMathEx.isSame2D(p, pa1) && !ToolMathEx.isSame2D(p, pa2)) {
							double mid = (double)(ToolMathEx.getAngle2D(c.mCp.x, c.mCp.y, p.x, p.y) * 180 / Math.PI);
							GCircle gc = new GCircle(new Point2d(c.mCp.x, c.mCp.y), c.mR, mid, c.mEnd);
							c.mEnd = mid;
							LinkedPoint2Df lp = new LinkedPoint2Df(p.x, p.y);

							lp.mFlagObj = gc;
							a.insertElementAt(lp, ita);
						}
					}
				}
				ToolMathEx.getSort(pts, pb1);
				for (int i = 0; i < 2; i++) {
					if ((p = pts[i]) != null) {
						if (!ToolMathEx.isSame2D(p, pb1) && !ToolMathEx.isSame2D(p, pb2)) {
							b.insertElementAt(new LinkedPoint2Df(p.x, p.y), itb);
						}
					}
				}
			}
		//b側にのみサークル存在
		} else if (pa1.mFlagObj == null && pb1.mFlagObj != null) {
			GCircle c = (GCircle)pb1.mFlagObj;
			Point2d[] pts = ToolMathEx.isCrossArcAndLine(pa1, pa2, c);
			if (pts != null) {
				Point2d p;
				ToolMathEx.getSort(pts, c);
				for (int i = 0; i < 2; i++) {
					if ((p = pts[i]) != null) {
						if (!ToolMathEx.isSame2D(p, pb1) && !ToolMathEx.isSame2D(p, pb2)) {
							double mid = (double)(ToolMathEx.getAngle2D(c.mCp.x, c.mCp.y, p.x, p.y) * 180 / Math.PI);
							GCircle gc = new GCircle(new Point2d(c.mCp.x, c.mCp.y), c.mR, mid, c.mEnd);
							c.mEnd = mid;
							LinkedPoint2Df lp = new LinkedPoint2Df(p.x, p.y);
							lp.mFlagObj = gc;
							b.insertElementAt(lp, itb);
						}
					}
				}
				ToolMathEx.getSort(pts, pa1);
				for (int i = 0; i < 2; i++) {
					if ((p = pts[i]) != null) {
						if (!ToolMathEx.isSame2D(p, pa1) && !ToolMathEx.isSame2D(p, pa2)) {
							a.insertElementAt(new LinkedPoint2Df(p.x, p.y), ita);
						}
					}
				}
			}

		//両方サークル
		} else if (pa1.mFlagObj != null && pb1.mFlagObj != null) {
			GCircle c1 = (GCircle)pa1.mFlagObj;
			GCircle c2 = (GCircle)pb1.mFlagObj;
			Point2d[] pts = ToolMathEx.isCrossArc(c1, c2);

			if (pts != null) {
				Point2d p;
				ToolMathEx.getSort(pts, c1);
				for (int i = 0; i < 2; i++) {
					if ((p = pts[i]) != null) {
						if (!ToolMathEx.isSame2D(p, pa1) && !ToolMathEx.isSame2D(p, pa2)) {
							double mid = (double)(ToolMathEx.getAngle2D(c1.mCp.x, c1.mCp.y, p.x, p.y) * 180 / Math.PI);
							GCircle gc = new GCircle(new Point2d(c1.mCp.x, c1.mCp.y), c1.mR, mid, c1.mEnd);
							c1.mEnd = mid;
							LinkedPoint2Df lp = new LinkedPoint2Df(p.x, p.y);
							lp.mFlagObj = gc;
							a.insertElementAt(lp, ita);
						}
					}
				}
				ToolMathEx.getSort(pts, c2);
				for (int i = 0; i < 2; i++) {
					if ((p = pts[i]) != null) {
						if (!ToolMathEx.isSame2D(p, pb1) && !ToolMathEx.isSame2D(p, pb2)) {
							double mid = (double)(ToolMathEx.getAngle2D(c2.mCp.x, c2.mCp.y, p.x, p.y) * 180 / Math.PI);
							GCircle gc = new GCircle(new Point2d(c2.mCp.x, c2.mCp.y), c2.mR, mid, c2.mEnd);
							c2.mEnd = mid;
							LinkedPoint2Df lp = new LinkedPoint2Df(p.x, p.y);
							lp.mFlagObj = gc;
							b.insertElementAt(lp, itb);
						}
					}
				}
			}
		}
	}
*/

	/**
	 * 円上に存在する点群（2個）を角度が大きいものの順にソート
	 */
	public static void getSort(Point2d[] pts, GCircle c) {
		if (pts[0] != null && pts[1] != null) {
			double cx = c.getX();
			double cy = c.getY();
			double angl1 = (ToolMath.getAngle2D(cx, cy, pts[0].x, pts[0].y) * 180 / Math.PI);
			double angl2 = (ToolMath.getAngle2D(cx, cy, pts[1].x, pts[1].y) * 180 / Math.PI);
			angl1 = ToolMath.getAngl360(angl1 - c.getStart());
			angl2 = ToolMath.getAngl360(angl2 - c.getEnd());
			if (angl1 < angl2) {
				Point2d tmp = pts[0];
				pts[0] = pts[1];
				pts[1] = tmp;
			}
		}
	}

	/**
	 * P1に近いもの順にソート
	 */
	public static void getSort(Point2d[] pts, Point2d p1) {
		if (pts[0] != null && pts[1] != null) {
			double len1 = ToolMath.getLength2D(p1.x, p1.y, pts[0].x, pts[0].y);
			double len2 = ToolMath.getLength2D(p1.x, p1.y, pts[1].x, pts[1].y);
			if (len1 < len2) {
				Point2d tmp = pts[0];
				pts[0] = pts[1];
				pts[1] = tmp;
			}
		}
	}


	/**
	 * 象限を調べる。
	 * @param px 検査する点のX座標
	 * @param py 検査する点のY座標
	 * @param x1 点１のX座標
	 * @param y1 点１のY座標
	 * @param x2 点２のX座標
	 * @param y2 点２のY座標
	 */
//	public static int getQuadrant(double px, double py, double x1, double y1, double x2, double y2) {
//		double baseangl = getAngle2D(x1, y1, x2, y2);
//		double angl = getAngle2D(x1, y1, px, py);
//		double res = angl - baseangl < 0.0f ? angl - baseangl + (Math.PI * 2): angl - baseangl;
//
//		if (res >= 0.0f && res < (Math.PI / 2))
//			return 1;
//		else if (res >= (Math.PI / 2) && res < Math.PI)
//			return 2;
//		else if (res >= (Math.PI) && res < (Math.PI / 2 * 3))
//			return 3;
//		else
//			return 4;
//	}

	/**
	 * 角度（ラジアン）を２＊PIの範疇に変更する
	 * @param d
	 * @return
	 */
//	public static double getAngl2PI(double d) {
//		while(d < 0)
//			d += (Math.PI * 2);
//		while(d > (Math.PI * 2))
//			d -= (Math.PI * 2);
//		return d;
//	}

	/**
	 * 角度（度）360度をの範疇に変更する
	 * @param d
	 * @return
	 */
//	public static double getAngl360(double d) {
//		while(d < 0)
//			d += 360;
//		while(d > 360)
//			d -= 360;
//		return d;
//	}

	/**
	 * ２Dでの点の回転
	 * @param xc 回転中心のX座標
	 * @param yc 回転中心のX座標
	 * @param rot 回転角度
	 * @param xsrc 対象の点のX座標
	 * @param ysrc 対象の点のY座標
	 * @param res 結果座標
	 */
//	public static void rotation2D(double xc, double yc, double rot, double xsrc,double ysrc,double res[]) {
//		double cc,ss;
//
//		cc = Math.cos(-rot);
//		ss = Math.sin(-rot);
//
//		xsrc -= xc;
//		ysrc -= yc;
//		if (res != null) {
//			res[0] = norm( xsrc * cc + ysrc * ss + xc);
//			res[1] = norm(-xsrc * ss + ysrc * cc + yc);
//		}
//	}

	/**
	 * 2次元の2点の間の距離を調べる
	 * @param x1 点１のX座標
	 * @param y1 点１のY座標
	 * @param x2 点２のX座標
	 * @param y2 点２のY座標
	 */
	public static double getLength2D(Point2d p1, Point2d p2)	{
		return getLength2D(p1.x, p1.y, p2.x, p2.y);
	}

	/**
	 * 2点が同じ位置にあるか検査
	 * @param p1x 点1のX座標
	 * @param p1y 点1のY座標
	 * @param p2x 点2のX座標
	 * @param p2y 点2のY座標
	 */
	public static boolean isSame2D(Point2d p1, Point2d p2) {
		return isSame2D(p1.x, p1.y, p2.x, p2.y);
	}

	/**
	 * 2直線が同じか調べる
	 * @param pa1x 点１
	 *
	 */
	public static boolean isSameLine(Point2d p1, Point2d p2, Point2d pa, Point2d pb) {
		return isSameLine(p1.x, p1.y, p2.x, p2.y, pa.x, pa.y, pb.x, pb.y);
	}

	/**
	 * 線分p1-p2が線分p3-p4に含まれるか
	 */
	public static boolean inIncludeLine(Point2d p1, Point2d p2, Point2d p3, Point2d p4) {
		return inIncludeLine(p1.x, p1.y, p2.x, p2.y, p3.x, p3.y, p4.x, p4.y);
	}

	/**
	 * 点と線分の距離を調べる
	 * @param px 検査する点のX座標
	 * @param py 検査する点のY座標
	 * @param p1x 線分の点1のx座標
	 * @param p1y 線分の点1のY座標
	 * @param p2x 線分の点2のx座標
	 * @param p2y 線分の点2のY座標
	 */
	public static double distanceLimitLineToPoint2D (double px, double py, Point2d p1, Point2d p2) {
		return getLengthLimitLineToPoint2D(px, py, p1.x, p1.y, p2.x, p2.y);
//		double xp1, yp1, x21, y21;
//		double denom;
//		xp1 = p1x - px;
//		yp1 = p1y - py;
//		x21 = p2x - p1x;
//		y21 = p2y - p1y;
//		denom = x21 * x21 + y21 * y21;
//
//		double t = -(xp1 * x21 + yp1 * y21) / denom;
//
//		if ( t >= 0.0f && t <= 1.0f) {
//			double x, y;
//			x = xp1 + t * x21;
//			y = yp1 + t * y21;
//			return norm(Math.sqrt(x * x + y * y));
//		}
//		return -1.0;
	}

	/**
	 * 点から直線(無限)に垂直に降ろした交点を調べる
	 * @param	px	検査する点のX座標
	 * @param	py	検査する点のY座標
	 * @param	p1x	線の点１のX座標
	 * @param	p1y	線の点１のY座標
	 * @param	p2x	線の点２のX座標
	 * @param	p2y	線の点２のY座標
	 */
	public static boolean verticalLimitlessLineToPoint2D(double px, double py, Point2d p1, Point2d p2, double[] res) {
		return isCrossPointVertLimitlessLineToPoint2D(px, py, p1.x, p1.y, p2.x, p2.y, res);
//		//線１の方程式
//		double a1 = getLineEquatin2Da(p1x, p1y, p2x, p2y);
//		double b1 = getLineEquatin2Db(p1x, p1y, p2x, p2y);
//		double c1 = getLineEquatin2Dc(p1x, p1y, p2x, p2y);
//		//線２の方程式
//		double a2 = b1;
//		double b2 = -a1;
//		double c2 = a1 * py - b1 * px;
//
//		double det = a1 * b2 - a2 * b1;
//		if (Math.abs(det) < EPS)
//			return false;
//		if (res != null) {
//			res[0] = norm((b1 * c2 - b2 * c1) / det);
//			res[1] = norm((a2 * c1 - a1 * c2) / det);
//		}
//		return true;
	}

	/**
	 * 点と直線(無限)の距離を調べる
	 *
	 * @param	px	検査する点のX座標
	 * @param	py	検査する点のY座標
	 * @param	p1x	線分の点1のx座標
	 * @param	p1y	線分の点1のY座標
	 * @param	p2x	線分の点2のx座標
	 * @param	p2y	線分の点2のY座標
	 *
	 * @return	点と線分の距離。計算できなければ-1を返す。
	 */
	public static double distanceLimitlessLineToPoint2D (Point2d p, Point2d p1, Point2d p2) {
		return getLengthLimitlessLineToPoint2D(p.x, p.y, p1.x, p1.y, p2.x, p2.y);
	}
//		if (isSame2D(p1x, p1y, p2x, p2y))
//			return -1f;
//
//		//直線の方程式を算出
//		double a = getLineEquatin2Da(p1x, p1y, p2x, p2y);
//		double b = getLineEquatin2Db(p1x, p1y, p2x, p2y);
//		double c = getLineEquatin2Dc(p1x, p1y, p2x, p2y);
//
//		//距離を調べる
//		double absq = a * a + b * b;
//		if (absq < EPS)
//			return -1f;
//		double sr = a * px + b * py + c;
//		return norm(Math.sqrt(sr * sr / absq));
//	}

	/**
	 * 点と直線(無限)の位置を調べる
	 *
	 * @param	px	検査する点のX座標
	 * @param	py	検査する点のY座標
	 * @param	p1x	線分の点1のx座標
	 * @param	p1y	線分の点1のY座標
	 * @param	p2x	線分の点2のx座標
	 * @param	p2y	線分の点2のY座標
	 *
	 * @return	上にあればtrue.下ならfalse。
	 */
	public static boolean isPointPickUporDown(double px, double py, Point2d p1, Point2d p2) {
		return isPointPickUporDown(px, py, p1.x, p1.y, p2.x, p2.y);
	}

	/**
	 * 点１から点２の方向にofsx,
	 * そこから垂直にofsy（左が正）の位置を算出
	 *
	 * @param	x1		点１のX座標
	 * @param	y1		点１のY座標
	 * @param	x2		点２のX座標
	 * @param	y2		点２のY座標
	 * @param	ofsx	xオフセット(線方向)
	 * @param	ofsy	yオフセット(法線方向)
	 * @param	res		結果座標
	 */
	public static void getOffsetPoint2D(Point2d p1, Point2d p2, double ofsx, double ofsy, double[] res) {
		getOffsetPoint2D(p1.x, p1.y, p2.x, p2.y, ofsx, ofsy, res);
	}

	public static Point2d getOffsetPoint2D(Point2d p1, Point2d p2, double ofsx, double ofsy) {
		double[] tmpf = new double[2];
		getOffsetPoint2D(p1.x, p1.y, p2.x, p2.y, ofsx, ofsy, tmpf);
		return new Point2d(tmpf[0], tmpf[1]);
	}

	/**
	 * @param x1
	 * @param y1
	 * @param x2
	 * @param y2
	 * @param ofsx
	 * @param ofsy
	 * @param res
	 */
//	public static void getOffsetLength2D(double x1, double y1, double x2, double y2, double ofsx, double ofsy, double[] res) {
//		double angl = getAngle2D(x1, y1, x2, y2);
//		if (res != null) {
//			res[0] = (double)((ofsx * Math.cos(angl)) + (ofsy * Math.cos(angl + Math.PI / 2.0)));
//			res[1] = (double)((ofsx * Math.sin(angl)) + (ofsy * Math.sin(angl + Math.PI / 2.0)));
//		}
//	}

	/**
	 * 2線分が交点を持つか調べる
	 *
	 * @param	ap1x	線１の点１のX座標
	 * @param	ap1y	線１の点１のY座標
	 * @param	bp1x	線２の点１のX座標
	 * @param	bp1y	線２の点１のY座標
	 * @param	res		結果座標
	 */
	public static boolean isLimitLineCross2D(Point2d p1, Point2d p2, Point2d pa, Point2d pb, double[] res) {
		return isCrossSegment(p1.x, p1.y, p2.x, p2.y, pa.x, pa.y, pb.x, pb.y, res);
	}

	/**
	 * 2直線(無限)が交点を持つか調べる
	 *
	 * @param	ap1x	線１の点１のX座標
	 * @param	ap1y	線１の点１のY座標
	 * @param	ap2x	線１の点２のX座標
	 * @param	ap2y	線１の点２のY座標
	 * @param	bp1x	線２の点１のX座標
	 * @param	bp1y	線２の点１のY座標
	 * @param	bp2x	線２の点２のX座標
	 * @param	bp2y	線２の点２のY座標
	 * @param	res		結果座標
	 */
//	public static boolean isLimitlessLineCross2D(double ap1x, double ap1y, double ap2x, double ap2y, double bp1x, double bp1y, double bp2x, double bp2y, double[] res) {
//		//線１の方程式
//		double a1 = getLineEquatin2Da(ap1x, ap1y, ap2x, ap2y);
//		double b1 = getLineEquatin2Db(ap1x, ap1y, ap2x, ap2y);
//		double c1 = getLineEquatin2Dc(ap1x, ap1y, ap2x, ap2y);
//		//線２の方程式
//		double a2 = getLineEquatin2Da(bp1x, bp1y, bp2x, bp2y);
//		double b2 = getLineEquatin2Db(bp1x, bp1y, bp2x, bp2y);
//		double c2 = getLineEquatin2Dc(bp1x, bp1y, bp2x, bp2y);
//
//		double det = a1 * b2 - a2 * b1;
//		if (Math.abs(det) < EPS)
//			return false;
//		if (res != null) {
//			res[0] = norm((b1 * c2 - b2 * c1) / det);
//			res[1] = norm((a2 * c1 - a1 * c2) / det);
//		}
//		return true;
//	}

	/**
	 * 2直線が同一線上に存在するか
	 *
	 * @param	ap1x	線１の点１のX座標
	 * @param	ap1y	線１の点１のY座標
	 * @param	ap2x	線１の点２のX座標
	 * @param	ap2y	線１の点２のY座標
	 * @param	bp1x	線２の点１のX座標
	 * @param	bp1y	線２の点１のY座標
	 * @param	bp2x	線２の点２のX座標
	 * @param	bp2y	線２の点２のY座標
	 */
	public static boolean isOnLine(Point2d ap1, Point2d ap2, Point2d bp1, Point2d bp2) {
		return isOnLine(ap1.x, ap1.y, ap2.x, ap2.y, bp1.x, bp1.y, bp2.x, bp2.y);
	}

	/**
	 * 点が線分上にあるか調べる
	 *
	 * @param	px	検査する点のX座標
	 * @param	py	検査する点のY座標
	 * @param	p1x	線分の点１のX座標
	 * @param	p1y	線分の点１のY座標
	 * @param	p2x	線分の点２のX座標
	 * @param	p2y	線分の点２のY座標
	 */
	public static boolean isOnLimitLinePoint2D(Point2d p, Point2d p1, Point2d p2) {
		return isOnLimitLinePoint2D(p.x, p.y, p1.x, p1.y, p2.x, p2.y);
	}

	/**
	 *  2直線が平行か調べる
	 * @param	ap1x	線１の点１のX座標
	 * @param	ap1y	線１の点１のY座標
	 * @param	ap2x	線１の点２のX座標
	 * @param	ap2y	線１の点２のY座標
	 * @param	bp1x	線２の点１のX座標
	 * @param	bp1y	線２の点１のY座標
	 * @param	bp2x	線２の点２のX座標
	 * @param	bp2y	線２の点２のY座標
	 */
	public static boolean isParallel2D(Point2d p1, Point2d p2, Point2d pa, Point2d pb) {
		return isParallel2D(p1.x, p1.y, p2.x, p2.y, pa.x, pa.y, pb.x, pb.y);
	}

//	public static boolean get2LineOffsetCross(double x1, double y1, double x2, double y2, double x3, double y3, double ofs1, double ofs2, double[] tmp) {
//		if (isParallel2D(x1, y1, x2, y2, x2, y2, x3, y3)) {
//			getOffsetPoint2D(x2, y2, x3, y3, 0, ofs1, tmp);
//			return true;
//		}
//
//		double p1x, p1y, p2x, p2y, p3x, p3y, p4x, p4y;
//		getOffsetPoint2D(x1, y1, x2, y2, 0, ofs1, tmp);
//		p1x = norm(tmp[0]);
//		p1y = norm(tmp[1]);
//		getOffsetPoint2D(x2, y2, x1, y1, 0, -ofs1, tmp);
//		p2x = norm(tmp[0]);
//		p2y = norm(tmp[1]);
//		getOffsetPoint2D(x2, y2, x3, y3, 0, ofs2, tmp);
//		p3x = norm(tmp[0]);
//		p3y = norm(tmp[1]);
//		getOffsetPoint2D(x3, y3, x2, y2, 0, -ofs2, tmp);
//		p4x = norm(tmp[0]);
//		p4y = norm(tmp[1]);
//		return isLimitlessLineCross2D(p1x, p1y, p2x, p2y, p3x, p3y, p4x, p4y, tmp);
//	}

	/**
	 * 直線と円弧のオフセットした交点の取得
	 */
	public static boolean get2LineOffsetCross(double cx, double cy, double r, double s, double e, double x1, double y1, double x3, double y3, double ofs1, double ofs2, double[] tmp) {
		r += ofs1;
		double p1x, p1y, p3x, p3y;
		getOffsetPoint2D(x1, y1, x3, y3, 0, ofs2, tmp);
		p1x = norm(tmp[0]);
		p1y = norm(tmp[1]);

		getOffsetPoint2D(x3, y3, x1, y1, 0, -ofs2, tmp);
		p3x = norm(tmp[0]);
		p3y = norm(tmp[1]);

		isCrossArcAndLine(p1x, p1y, p3x, p3y, cx, cy, r, s, e);
		return false;
	}


	/**
	 * 直線の方程式の切片Aを算出
	 *
	 * @param	p1x	線分の点1のx座標
	 * @param	p1y	線分の点1のY座標
	 * @param	p2x	線分の点2のx座標
	 * @param	p2y	線分の点2のY座標
	 *
	 * @return	点と線分の距離。計算できなければ-1を返す。
	 */
//	protected static double getLineEquatin2Da (double p1x, double p1y, double p2x, double p2y) {
//		double xlk = p2x - p1x;
//		double ylk = p2y - p1y;
//		double rsq = xlk * xlk + ylk * ylk;
//
//		double rinv = 1.f/ Math.sqrt(rsq);
//		return norm(-ylk * rinv);
//	}

	/**
	 * 直線の方程式の切片Bを算出
	 *
	 * @param	p1x	線分の点1のx座標
	 * @param	p1y	線分の点1のY座標
	 * @param	p2x	線分の点2のx座標
	 * @param	p2y	線分の点2のY座標
	 *
	 * @return	点と線分の距離。計算できなければ-1を返す。
	 */
//	protected static double getLineEquatin2Db (double p1x, double p1y, double p2x, double p2y) {
//		double xlk = p2x - p1x;
//		double ylk = p2y - p1y;
//		double rsq = xlk * xlk + ylk * ylk;
//
//		double rinv = 1.f/ Math.sqrt(rsq);
//		return norm(xlk * rinv);
//	}

	/**
	 * 直線の方程式の切片Cを算出
	 *
	 * @param	p1x	線分の点1のx座標
	 * @param	p1y	線分の点1のY座標
	 * @param	p2x	線分の点2のx座標
	 * @param	p2y	線分の点2のY座標
	 *
	 * @return	点と線分の距離。計算できなければ-1を返す。
	 */
//	protected static double getLineEquatin2Dc(double p1x, double p1y, double p2x, double p2y) {
//		double xlk = p2x - p1x;
//		double ylk = p2y - p1y;
//		double rsq = xlk * xlk + ylk * ylk;
//
//		double rinv = 1.f/ Math.sqrt(rsq);
//		return norm((p1x * p2y - p2x * p1y) * rinv);
//	}

	/**
	 * 線分と円弧の交点を計算。
	 */
	public static Point2d[] isCrossArcAndLine(Point2d p1, Point2d p2 , GCircle cir) {
		return isCrossArcAndLine(p1.x, p1.y, p2.x, p2.y, cir.getX(), cir.getY(), cir.getR(), cir.getStart(), cir.getEnd());
	}

	public static Point2d[] isCrossArcAndLine(double p1x, double p1y, double p2x, double p2y , double cx, double cy, double r, double s, double e) {
		Point2d[] pt = isCrossCircleAndLine(p1x, p1y, p2x, p2y, cx, cy, r);
		if (pt == null)
			return null;
		for (int i = 0; i < 2; i++) {
			if (pt[i] != null) {
				double angl = getAngl360(getAngle2D(cx, cy, pt[i].x, pt[i].y) * 180 / Math.PI);
				if (!ToolMath.isInnerAngl2PI(s, e, angl))
					pt[i] = null;
			}
		}
		if (pt[0] == null && pt[1] == null)
			return null;
		return pt;
	}

	/**
	 * 線分と円周上の交点を計算。
	 */
	public static Point2d[] isCrossCircleAndLine(Point2d p1, Point2d p2 , GCircle cir) {
		return isCrossCircleAndLine(p1.x, p1.y, p2.x, p2.y, cir.getX(), cir.getY(), cir.getR());
	}

	public static Point2d[] isCrossCircleAndLine(double p1x, double p1y, double p2x, double p2y, double cx, double cy, double r) {
		Point2d[] pts = isCrossCircleAndLineNoLimit(p1x, p1y, p2x, p2y, cx, cy, r);
		if (pts == null)
			return null;
/*		double len = getLength2D(p1x, p1y, p2x, p2y);
		double f = (p2x - p1x) / len;
		double g = (p2y - p1y) / len;
		double fsq = f * f;
		double gsq = g * g;
		double fgsq = fsq + gsq;
		if (fgsq < -EPS)
			return null;

		double xjo = cx - p1x;
		double yjo = cy - p1y;
		double fygx = f * yjo - g * xjo;
		double root = r * r * fgsq - fygx * fygx;
		if (root < EPS)
			return null;
		Point2d[] pts = new Point2d[2];
		double fxgy = f * xjo + g * yjo;
		if (root < EPS) {
			pts[0] = new Point2d();
			double t = fxgy / fgsq;
			pts[0].x = (double)(p1x + f * t);
			pts[0].y = (double)(p1y + g * t);
		} else {
			root = Math.sqrt(root);
			double fginv = 1 / fgsq;
			double t1 = (fxgy - root) / fgsq;
			double t2 = (fxgy + root) / fgsq;
			pts[0] = new Point2d();
			pts[1] = new Point2d();
			pts[0].x = (double)(p1x + f * t1);
			pts[0].y = (double)(p1y + g * t1);
			pts[1].x = (double)(p1x + f * t2);
			pts[1].y = (double)(p1y + g * t2);
		}*/
		if (pts[0] != null && !isOnLimitLinePoint2D(pts[0].x, pts[0].y, p1x, p1y, p2x, p2y))
			pts[0] = null;
		if (pts[1] != null && !isOnLimitLinePoint2D(pts[1].x, pts[1].y, p1x, p1y, p2x, p2y))
			pts[1] = null;
		if (pts[0] == null && pts[1] == null)
			return null;
		if (pts[0] == null) {
			pts[0] = pts[1];
			pts[1] = null;
		}
		return pts;
	}

	public static Point2d[] isCross2Circle(double x1, double y1, double r1, double x2, double y2, double r2) {
		double rksq = r1 * r1;
		double rlsq = r2 * r2;
		double xlk = x2 - x1;
		double ylk = y2 - y1;
		double distsq = xlk * xlk + ylk * ylk;
		if (distsq < EPS)
			return null;
		double delrsq = rlsq - rksq;
		double sumrsq = rksq + rlsq;
		double root = 2*sumrsq * distsq - distsq * distsq - delrsq * delrsq;
		if (root < -EPS)
			return null;
		double dstinv = .5 / distsq;
		double scl = .5 - delrsq * dstinv;
		double x = xlk * scl + x1;
		double y = ylk * scl + y1;
		if (root < EPS)
			return new Point2d[]{new Point2d(x, y)};
		root = dstinv * Math.sqrt(root);
		double xfac = xlk * root;
		double yfac = ylk * root;
		return new Point2d[] {new Point2d((x - yfac), (y + xfac)), new Point2d((x + yfac), (y - xfac))};
	}

	/**
	 * 円と直線(無限)の交点を計算
	 * @param p1x
	 * @param p1y
	 * @param p2x
	 * @param p2y
	 * @param cx
	 * @param cy
	 * @param r
	 * @return
	 */
	public static Point2d[] isCrossCircleAndLineNoLimit(double p1x, double p1y, double p2x, double p2y, double cx, double cy, double r) {
		double len = getLength2D(p1x, p1y, p2x, p2y);
		double f = (p2x - p1x) / len;
		double g = (p2y - p1y) / len;
		double fsq = f * f;
		double gsq = g * g;
		double fgsq = fsq + gsq;
//		if (fgsq < -EPS)
		if (fgsq < -r / 100)
			return null;

		double xjo = cx - p1x;
		double yjo = cy - p1y;
		double fygx = f * yjo - g * xjo;
		double root = r * r * fgsq - fygx * fygx;
//		if (root < -EPS)
		if (root < -r / 100)
			return null;
		Point2d[] pts = new Point2d[2];
		double fxgy = f * xjo + g * yjo;
		if (root < EPS) {
			pts[0] = new Point2d();
			double t = fxgy / fgsq;
			pts[0].x = (p1x + f * t);
			pts[0].y = (p1y + g * t);
		} else {
			root = Math.sqrt(root);
//			double fginv = 1 / fgsq;
			double t1 = (fxgy - root) / fgsq;
			double t2 = (fxgy + root) / fgsq;
			pts[0] = new Point2d();
			pts[1] = new Point2d();
			pts[0].x = (p1x + f * t1);
			pts[0].y = (p1y + g * t1);
			pts[1].x = (p1x + f * t2);
			pts[1].y = (p1y + g * t2);
		}
		return pts;

	}
	/**
	 * 円弧と円弧の交点を計算。
	 */
	public static Point2d[] isCrossArc(GCircle ck, GCircle cl) {
		return isCrossArc(ck.getX(), ck.getY(), ck.getR(), ck.getStart(), ck.getEnd(), cl.getX(), cl.getY(), cl.getR(), cl.getStart(), cl.getEnd());
	}
	public static Point2d[] isCrossArc(double ckx, double cky, double ckr, double cks, double cke, double clx, double cly, double clr, double cls, double cle) {
		Point2d[] pts = isCrossCircle(ckx, cky, ckr, clx, cly, clr);
		if (pts == null)
			return null;
		if (pts[0] != null) {
			double ak = getAngle2D(ckx, cky, pts[0].x, pts[0].y) * 180 / Math.PI;
			double al = getAngle2D(clx, cly, pts[0].x, pts[0].y) * 180 / Math.PI;
			if (!isInnerAngl2PI(cks, cke, ak) || !isInnerAngl2PI(cls, cle, al))
				pts[0] = null;
		}
		if (pts[1] != null) {
			double ak = getAngle2D(ckx, cky, pts[1].x, pts[1].y) * 180 / Math.PI;
			double al = getAngle2D(clx, cly, pts[1].x, pts[1].y) * 180 / Math.PI;
			if (!isInnerAngl2PI(cks, cke, ak) || !isInnerAngl2PI(cls, cle, al))
				pts[1] = null;
		}
		if (pts[0] == null && pts[1] == null) {
			return null;
		} else if (pts[0] == null) {
			pts[0] = pts[1];
			pts[1] = null;
		}
		return pts;
	}

	/**
	 * 円と円の交点を計算。
	 */
	public static Point2d[] isCrossCircle(GCircle ck, GCircle cl) {
		return isCrossCircle(ck.getX(), ck.getY(), ck.getR(), cl.getX(), cl.getY(), cl.getR());
//		double rksq = ck.mR * ck.mR;
//		double rlsq = cl.mR * cl.mR;
//		double xlk = cl.mCp.x - ck.mCp.x;
//		double ylk = cl.mCp.y - ck.mCp.y;
//		double distsq = xlk * xlk + ylk * ylk;
//		if (distsq < EPS)
//			return null;
//		double delrsq = rlsq - rksq;
//		double sumrsq = rksq + rlsq;
//		double root = 2 * sumrsq * distsq - distsq * distsq - delrsq * delrsq;
//		if (root < -EPS)
//			return null;
//		Point2d[] pts = new Point2d[2];
//		double dstinv = .5 / distsq;
//		double scl = .5 - delrsq * dstinv;
//		double x = xlk * scl + ck.mCp.x;
//		double y = ylk * scl + ck.mCp.y;
//		if (root < EPS) {
//			pts[0] = new Point2d((double)x, (double)y);
//		} else {
//			root = dstinv * Math.sqrt(root);
//			double xfac = xlk * root;
//			double yfac = ylk * root;
//			pts[0] = new Point2d((double)(x - yfac), (double)(y + xfac));
//			pts[1] = new Point2d((double)(x + yfac), (double)(y - xfac));
//		}
//		return pts;
	}
	public static Point2d[] isCrossCircle(double ckx, double cky, double ckr, double clx, double cly, double clr) {
		double rksq = ckr * ckr;
		double rlsq = clr * clr;
		double xlk = clx - ckx;
		double ylk = cly - cky;
		double distsq = xlk * xlk + ylk * ylk;
		if (distsq < EPS)
			return null;
		double delrsq = rlsq - rksq;
		double sumrsq = rksq + rlsq;
		double root = 2 * sumrsq * distsq - distsq * distsq - delrsq * delrsq;
		if (root < -EPS)
			return null;
		Point2d[] pts = new Point2d[2];
		double dstinv = .5 / distsq;
		double scl = .5 - delrsq * dstinv;
		double x = xlk * scl + ckx;
		double y = ylk * scl + cky;
		if (root < EPS) {
			pts[0] = new Point2d(x, y);
		} else {
			root = dstinv * Math.sqrt(root);
			double xfac = xlk * root;
			double yfac = ylk * root;
			pts[0] = new Point2d((x - yfac), (y + xfac));
			pts[1] = new Point2d((x + yfac), (y - xfac));
		}
		return pts;
	}
	/**
	 * 丸める
	 */
//	protected static double norm(double f) {
//		return (double)(Math.round(f * 1e8) / 1e8);
//	}


	/**
//	 * TEST
//	 * ２線から垂直に引いた線の交点の取得
//	 */
//	private static void aaa(Point2d p1, Point2d p2, double ofsx1, double ofsy1, Point2d p3, Point2d p4, double ofsx2, double ofsy2, double[] tmpf) {
//		double x1, y1, x2, y2;
//		double x3, y3, x4, y4;
//		ToolMathEx.getOffsetPoint2D(p1, p2, ofsx1, 0, tmpf);
//		x1 = tmpf[0];
//		y1 = tmpf[1];
//		ToolMathEx.getOffsetPoint2D(p1, p2, ofsx1, ofsy1, tmpf);
//		x2 = tmpf[0];
//		y2 = tmpf[1];
//
//		ToolMathEx.getOffsetPoint2D(p3, p4, ofsx2, 0, tmpf);
//		x3 = tmpf[0];
//		y3 = tmpf[1];
//		ToolMathEx.getOffsetPoint2D(p3, p4, ofsx2, ofsy2, tmpf);
//		x4 = tmpf[0];
//		y4 = tmpf[1];
//		ToolMath.isCrossInfinity(x1, y1, x2, y2, x3, y3, x4, y4, tmpf);
//	}

}
