/**
 *
 */
package nethome.geom.primitive;

import java.io.Serializable;

import jp.kitec.lib.geom.KLocalAxis;


/**
 * 移動拡大のみのlocalAxis
 * @since 2007/10/12
 * @author kamimura
 * @version 2007/10/12
 */
public class LocalAxis2dfs implements KLocalAxis, Serializable {
	private double mKx, mKy;
	private double mMx, mMy;
	/**
	 * コンストラクタ.
	 * @since 2007/10/12
	 * @author kamimura
	 */
	public LocalAxis2dfs() {
		super();
		mKx = mKy = 1;
		mMx = mMy = 0;
	}

	/**
	 * @param kx
	 * @param ky
	 * @param mx
	 * @param my
	 * @since 2007/10/12
	 * @author kamimura
	 * @version 2007/10/12
	 */
	public void setCoordinates(double kx, double ky, double mx, double my){
		this.mKx = kx;
		this.mKy = ky;
		this.mMx = mx;
		this.mMy = my;
	}

	/**
	 * @param x
	 * @param y
	 * @since 2007/10/12
	 * @author kamimura
	 * @version 2007/10/12
	 */
	public void setMXY(double x, double y){
		this.mMx = x;
		this.mMy = y;
	}

	public double getKx() {
		return mKx;
	}

	public double getKy() {
		return mKy;
	}

	public double getMx() {
		return mMx;
	}

	public double getMy() {
		return mMy;
	}

	/*
	 * @see jp.kitec.lib.geom.KLocalAxis#getGlobalX(double, double)
	 * @since 2007/10/12
	 */
	@Override
	public double getGlobalX(double x, double y) {
		return mKx * x + mMx;
	}

	/*
	 * @see jp.kitec.lib.geom.KLocalAxis#getGlobalY(double, double)
	 * @since 2007/10/12
	 */
	@Override
	public double getGlobalY(double x, double y) {
		return mKy * y + mMy;
	}

	/*
	 * @see jp.kitec.lib.geom.KLocalAxis#getLocalX(double, double)
	 * @since 2007/10/12
	 */
	@Override
	public double getLocalX(double x, double y) {
		return (x - mMx) / mKx;
	}

	/*
	 * @see jp.kitec.lib.geom.KLocalAxis#getLocalY(double, double)
	 * @since 2007/10/12
	 */
	@Override
	public double getLocalY(double x, double y) {
		return (y - mMy) / mKy;
	}

	/*
	 * @see jp.kitec.lib.geom.KLocalAxis#getGlobalAngl(double)
	 * @since 2007/10/12
	 */
	@Override
	public double getGlobalAngl(double rad) {
		return 0;
	}

}
