/*
 * Created on 2003/08/26
 */
package nethome.geom;

import java.io.Serializable;
import java.util.Vector;

import jp.kitec.lib.util.tree.ObjectFolder;

/**
 * シンボルの属性コレクション
 *
 * @author kawae
 */
public class SymbolAttributeCollection implements Serializable {

	/** 属性のコレクション */
	private Vector<SymbolAttribute> mAttributes;

	/**
	 * コンストラクタ
	 */
	public SymbolAttributeCollection() {
		mAttributes = new Vector<SymbolAttribute>();
	}

	/**
	 * コピーの取得
	 * @return
	 */
	public SymbolAttributeCollection getCopy() {
		SymbolAttributeCollection sac = new SymbolAttributeCollection();
		for (int i = 0; i < mAttributes.size(); i++) {
			SymbolAttribute sa = mAttributes.elementAt(i);
			sac.mAttributes.addElement(sa.getCopy());
		}
		return sac;
	}

	/**
	 * @deprecated typeは削除の方向で。
	 * 属性の追加
	 * @param key
	 * @param val
	 */
	@Deprecated
	public void addAttribute(short type, String key, String val, boolean copybuffer) {
		SymbolAttribute a = new SymbolAttribute();
		a.mKey = key;
		a.mValue = new String(val);
		a.mCopyBuffer = copybuffer;
		mAttributes.addElement(a);
	}

	/**
	 * 属性の追加
	 * @param key
	 * @param val
	 */
	public void addAttribute(String key, String val, boolean copybuffer) {
		SymbolAttribute a = new SymbolAttribute();
		a.mKey = key;
		a.mValue = new String(val);
		a.mCopyBuffer = copybuffer;
		mAttributes.addElement(a);
	}

	/**
	 * アトリビュートの設定
	 * @param sa
	 */
	public void addAttribute(SymbolAttribute sa) {
		mAttributes.addElement(sa);
	}

	/**
	 * アトリビュートの取得
	 * @param key
	 * @return
	 */
	public Vector<SymbolAttribute> getAttributes() {
		return mAttributes;
	}

	/**
	 * キーが存在するか
	 * @param key
	 * @return
	 */
	public boolean isHasAttribute(String key) {
		for (int i = 0; i < mAttributes.size(); i++) {
			SymbolAttribute sa = mAttributes.elementAt(i);
			if (sa.mKey.equalsIgnoreCase(key))
				return true;
		}
		return false;
	}

	/**
	 * キーの削除
	 * @param key
	 */
	public SymbolAttribute getAttribute(String key) {
		for (int i = 0; i < mAttributes.size(); i++) {
			SymbolAttribute sa = mAttributes.elementAt(i);
			if (sa.mKey.equalsIgnoreCase(key))
				return sa;
		}
		return null;
	}

	/**
	 * キーの削除
	 * @param key
	 */
	public void removeAttribute(String key) {
		for (int i = 0; i < mAttributes.size(); i++) {
			SymbolAttribute sa = mAttributes.elementAt(i);
			if (sa.mKey.equalsIgnoreCase(key))
				mAttributes.removeElement(sa);
		}
	}

	/**
	 * キーの削除
	 * @param key
	 */
	public void removeAttribute(SymbolAttribute sa) {
		if (mAttributes.contains(sa)) {
			mAttributes.removeElement(sa);
		}
	}

	/**
	 * 保存
	 * @param w
	 * @param space
	 * @throws Exception
	 */
	public void save(ObjectFolder savenode) throws Exception {
	    savenode.setName("SYMBOLATTRIBUTES");
		for (int i = 0; i < mAttributes.size(); i++) {
			SymbolAttribute sa = mAttributes.elementAt(i);
			ObjectFolder of = new ObjectFolder("");
			sa.save(of);
			savenode.addChild(of, true);
		}
	}

//	/**
//	 * 保存
//	 * @param w
//	 * @param space
//	 * @throws Exception
//	 */
//	public void saveGeom(AbstFile w, String space) throws Exception {
//		for (int i = 0; i < mAttributes.size(); i++) {
//			SymbolAttribute sa = (SymbolAttribute)mAttributes.elementAt(i);
//			sa.saveGeom(w, space);
//		}
//	}
}
