package nethome.geom;

import java.io.Serializable;

import jp.kitec.kwt.IRichGraphics;
import jp.kitec.lib.util.RefList;
import nethome.NethomeCoreLookAndFeel;
import nethome.NethomeCoreResource;
import nethome.geom.primitive.GLine;
import nethome.geom.primitive.GPoint2Df;

/**
 * 領域コントロールクラス
 * @author kawae
 */
public class AreaControl implements Serializable {

	/** 点群 */
	private RefList<GPoint2Df> _points;

	/** 線群 */
	private RefList<GLine> _lines;

	/** エリアのクローズオプション */
	private boolean mClose = true;

	/**
	 * コンストラクタ
	 */
	public AreaControl() {
		_points = new RefList<GPoint2Df>();
		_lines = new RefList<GLine>();
	}

	/**
	 * 初期化
	 */
	public void init() {
		_points.removeAllElements();
		_lines.removeAllElements();
	}

	public void setCloseMode(boolean f) {
		mClose = f;
	}

	public boolean getCloseMode() {
		return mClose;
	}
	/**
	 * 線群の作成
	 */
	public void close() {
		int ofs = mClose ? 0 : 1;
		_lines.removeAllElements();
		for (int i = 0; i < _points.size() - ofs; i++) {
			GPoint2Df p1 = _points.elementAt(i);
			GPoint2Df p2 = _points.elementAt(i + 1);
			_lines.addElement(new GLine(p1, p2));
		}
	}

	/**
	 * 点群の取得
	 * @return
	 */
	public RefList<GPoint2Df> getPoints() {
		return _points;
	}

	/**
	 * 線群の取得
	 */
	public RefList<GLine> getLines() {
		return _lines;
	}

	/**
	 * エリアのセット
	 */
	public void setArea(RefList<GPoint2Df> a) {
		_points.removeAllElements();
		_points = null;
		_points = new RefList<GPoint2Df>();
		for (int i = 0; i < a.size(); i++) 
			_points.addElement(a.elementAt(i));	
		close();
	}

	public void drawGeomHilight(IRichGraphics d) {
		if (_points.size() > 2 || !mClose) {
			int ofs = mClose ? 0 : 1;
			d.setColor(NethomeCoreLookAndFeel.SELECT_SYMBOL_COLOR);
			for (int i = 0; i < _points.size() - ofs; i++) {
				GPoint2Df p1 = _points.elementAt(i);
				GPoint2Df p2 = _points.elementAt(i + 1);

				d.drawLine(p1.x, p1.y, p2.x, p2.y, IRichGraphics.LINE_DASH_1);
			}
			for (int i = 0; i < _points.size(); i++) { 
				GPoint2Df pt = _points.elementAt(i);
				d.setColor(NethomeCoreLookAndFeel.SELECT_SYMBOL_COLOR);
				d.drawMark(pt.x, pt.y, NethomeCoreResource.MARKER_SIZE, IRichGraphics.MARK_REC_FILL);
				d.setColor(NethomeCoreLookAndFeel.SELECT_SYMBOL_MARK_FRAME_COLOR);
				d.drawMark(pt.x, pt.y, NethomeCoreResource.MARKER_SIZE, IRichGraphics.MARK_REC);
			}
		}
	}
}