/*
 * Copyright (c) 2004, 2010 KITec Inc,.. All rights reserved.
 * Created on 2004/09/07
 */
package nethome.doc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;

/**
 * コピー・カット用のバッファ
 * @author kawae
 */
public class CopyBuffer {

	/**
	 *  コピーモードか、カットモードかのフラグ
	 */
	protected boolean mCutMode;

	/** バッファ */
	private ArrayList<Object> mCopyBuffer;

	public CopyBuffer() {
		mCopyBuffer = new ArrayList<Object>();
	}

	public void clearBuffer() {
		mCopyBuffer.clear();
	}

	/**
	 * コピーバッファ無いにバッファが存在するか確認
	 * @return
	 */
	public boolean hasCopyBuffer() {
		return !mCopyBuffer.isEmpty();
	}

	/**
	 * カットモードか確認
	 * @return
	 */
	public boolean isCutMode() {
		return mCutMode;
	}

	/**
	 * カットバッファに追加
	 * @param target
	 * @return
	 */
	public boolean addCutBuffer(Object target) {
		if (target != null) {
			mCutMode = true;
			if (!mCopyBuffer.contains(target))
				mCopyBuffer.add(target);
			return true;
		}
		return false;
	}

	/**
	 * シリアライズしてコピーバッファに追加
	 *
	 * @param target
	 * @return
	 */
	public boolean addCopyBuffer(Object target) {
		return addCopyBuffer(target, true);
	}
	/**
	 * バッファに追加
	 *
	 * @param target		追加するオブジェクト
	 * @param serialize	シリアライズするか(true:シリアライズ,false:生のオブジェクトを格納)
	 *
	 * @return
	 */
	public boolean addCopyBuffer(Object target, boolean serialize) {
		if (target == null)
			return false;
		Object o = null;
		if (serialize) {
			try {
				ByteArrayOutputStream baus = new ByteArrayOutputStream();
				ObjectOutputStream oos = new ObjectOutputStream(baus);
				oos.writeObject(target);
				oos.close();
				baus.close();
				o = baus.toByteArray();
			} catch (Exception e) {
				return false;
			}
		} else {
			o = target;
		}
		mCutMode = false;
		if (!mCopyBuffer.contains(o))
			mCopyBuffer.add(o);
		return true;
	}

	/**
	 * コピーされているオブジェクトの一覧を取得
	 * @return
	 */
	public List<Object> getCopyElements() {
		ArrayList<Object> result = new ArrayList<Object>();
		for (int i = 0; i < mCopyBuffer.size(); i++) {
			Object o = mCopyBuffer.get(i);
			Object target = null;
			if (o instanceof byte[]) {
				try {
					ByteArrayInputStream bis = new ByteArrayInputStream((byte[])o);
					ObjectInputStream ois = new ObjectInputStream(bis);
					target = ois.readObject();
				} catch (Exception e) {
					target = o;
				}
			} else {
				target = o;
			}
			if (target != null)
				result.add(target);
		}
		return result;
	}
}
