package nethome.ui;

import jp.kitec.lib.io.FileSystem;
import nethome.doc.Document;
import nethome.doc.Project;
import nethome.lib.ObjectLibrary;

/**
 * 各種リソースのルート。
 * v4のMainComponent相当。
 * @author matsuzaki
 *
 */
public interface INethomeRuntime {

	public abstract ApplicationCore getApplication();

	/**
	 * ライブラリの取得
	 * @param key
	 * @return
	 */
	public abstract ObjectLibrary getLibrary(String key);

	/**
	 * ライブラリの登録
	 * @param key
	 * @param lib
	 */
	public abstract void registerLibrary(String key, ObjectLibrary lib);


	/**
	 * ファイルシステムの設定
	 * @param fs
	 */
	public void setFileSystem(FileSystem fs);

	/**
	 * ファイルシステムの取得
	 * @return
	 */
	public FileSystem getFileSystem();

	/**
	 * アクティブなドキュメントの取得
	 * @return Document
	 */
	public abstract Document getActiveDocument();

	/**
	 * アクティブなプロジェクトの取得
	 * @return
	 * @since 2004/12/03
	 * @author kawae
	 * @version 2004/12/03
	 *
	 */
	public abstract Project getActiveProject();

}