/*
 * Copyright (c) 2011 KITec Inc,.. All rights reserved.
 * @author matsuzaki
 */
package nethome.ui;

import jp.kitec.kwt.IRichGraphics;

/**
 * データを受け取ってKRichGraphicsに描画する
 * @author matsuzaki
 *
 * @param <DrawDataT>
 */
public interface CanvasDrawer<DrawDataT> {
	/**
	 * 静的なデータの表示。
	 * 再作図の指示があるまでキャッシュされる。
	 *
	 * @param data 表示するデータ
	 * @param g グラフィックスコンテキスト
	 */
	void draw(DrawDataT data, IRichGraphics g);

	/**
	 * 動的なデータの表示。
	 * paintのたびに再描画される。
	 *
	 * @param data 表示するデータ
	 * @param g グラフィックスコンテキスト
	 */
	void drawDynamic(DrawDataT data, IRichGraphics g);
}