/*
 * Copyright (c) 2011 KITec Inc,.. All rights reserved.
 * @author matsuzaki
 */
/**
 *
 */
package nethome.geom.primitive;

import javax.vecmath.Point2d;

/**
 * コントロールポイントで編集できる形状です。
 * @author matsuzaki
 *
 */
public interface IControllableGeometry {
	/** コントロールノードのステータス */
	/** 通常移動ステータス */
	public static final short CTRL_NODE_STATE_DEF = 0;
	/** フリー移動ステータス */
	public static final short CTRL_NODE_STATE_FREE = 1;

	/**
	 * コントロールポイントの数を返します。
	 */
	public int getControlPointSize();

	/**
	 * 指定されたインデックス位置にあるコントロールポイントを返します。
	 *
	 * @param index インデックス
	 */
	public Object getControlPoint(int index);

	/**
	 * 一番近いコントロールポイントを返します。
	 * @return Object	一番近いコントロールポイント
	 *
	 * @author kawae
	 * @since 2003/01/01
	 */
	public Object getNearControlPoint(double x, double y);

	/**
	 * コントロールポイントの座標を返します。
	 * @param cp コントロールポイント
	 * @return Point2d	コントロールポイントの座標
	 */
	public Point2d getControlPointPosition(Object cp);

	/**
	 * コントロールポイントの移動
	 *
	 * @param cp　コントロールポイント
	 * @param x	移動先ｘ
	 * @param y	移動先ｙ
	 * @author kawae
	 * @since 2003/01/01
	 */
	public void moveControlPoint(Object cp, double x, double y);

	/**
	 * コントロールポイントのステータスを返します。
	 *
	 * @param o
	 * @return
	 * @author kawae
	 * @since 2003/01/01
	 */
	public short getControlPointStatus(Object o);

	/**
	 * コントロールポイントがこのジオメトリのものかどうかを返します。
	 * @param o
	 * @return
	 */
	public boolean containsControlPoint(Object o);
}
