package nethome.doc;

import java.util.List;
import java.util.Map;

import jp.kitec.lib.util.tree.ObjectFolder;


/**
 * プロジェクトの基本単位
 *
 * @author kawae
 */
public interface Project {

	/**
	 * データの保存
	 * @return
	 */
	public ObjectFolder save();

	public void load(ObjectFolder rootf, DocumentFactory docFactory);


	/**
	 * レイヤーノードの読み込み
	 *
	 * @param layerf
	 * @param docFactory
	 * @author kawae
	 * @since 2005/10/07
	 */
	public Layer loadLayer(ObjectFolder layerf, DocumentFactory docFactory);

	/**
	 * レイヤーノードの読み込み
	 *
	 * @param layerf
	 * @param docFactory
	 * @author kawae
	 * @since 2005/11/02
	 */
	public Layer loadLayer(ObjectFolder layerf, DocumentFactory docFactory, boolean recover);

	/**
	 * プロジェクト情報の取得
	 * @return
	 */
	public Map<Object, Object> getProjectInfo();

	/**
	 * プロジェクト情報の特定のオブジェクトの取得
	 * @param key
	 * @return
	 */
	public Object getProjectInfo(Object key);

	/**
	 * レイヤーの追加
	 * @param lm
	 */
	public void addLayer(Layer l);

	/**
	 * 現在のレイヤーの設定
	 * @param i	レイヤーID
	 */
	public void setCurrentLayer(int i);

	/**
	 * 現在レイヤーの設定
	 * @param s	レイヤーの名前
	 */
	public void setCurrentLayer(String s);

	public List<Layer> getLayers();

	public void setSaved(boolean changed);

	public boolean isSaved();

	/**
	 * 現在のアクティブレイヤーの取得
	 * @return アクティブなレイヤー
	 */
	public Layer getCurrentLayer();

	/**
	 * ドキュメントのクリア
	 */
	public void documentRefresh();

	/**
	 * ヒストリのクリア
	 * @param o
	 */
	public void flushHistory();

	/**
	 * カレントフロアの最後のヒストリの取得
	 * @return
	 */
	public Object getLastHistory();

	/**
	 * カレントフロアの現在のヒストリの取得
	 * @return
	 */
	public Object getCurrentHistory();

	/**
	 * アンドゥ
	 */
	public boolean undo();

	/**
	 * リドゥ
	 */
	public boolean redo();

	/**
	 * ヒストリに追加
	 *
	 * @author kawae
	 * @since 2004/09/22
	 */
	public void addHistory();

	/**
	 * UNDOヒストリを持つか確認
	 *
	 * @return
	 * @author kawae
	 * @since 2004/11/23
	 */
	public boolean hasUndo();

	/**
	 * REDOヒストリを持つか確認
	 * @return
	 * @author kawae
	 * @since 2004/11/23
	 */
	public boolean hasRedo();

	/**
	 * 指定された数の履歴を保存する新たな履歴を構築する。
	 * @param num
	 */
	public void setMaxHistory(int num);

	/**
	 * プロジェクトの変更を通知するリスナーを通知リストに追加
	 * @param l
	 */
	public void addProjectListener(ProjectListener l);

	/**
	 * リスナーを通知リストから削除
	 * @param l
	 */
	public void removeProjectListener(ProjectListener l);

	/**
	 * プロジェクトが変更されたことを全てのリスナーに通知
	 */
	public void fireProjectChanged(Object source);
}
