/*
 * Created on 2003/08/26
 */
package nethome.geom;

import java.io.Serializable;

import jp.kitec.lib.util.tree.ObjectFolder;
import jp.kitec.lib.util.tree.ObjectNode;

/**
 * @author kawae
 */
public class SymbolAttribute implements Serializable {

	/** コピー操作時に属性もバッファするかのフラグ */
	public boolean mCopyBuffer = true;
	/** キー */
	public String mKey;
	/** オブジェクト */
	public String mValue;

	public static Object readData(ObjectFolder of, float version) throws Exception {
		SymbolAttribute sa = new SymbolAttribute();
		ObjectNode on = null;
		if ((on = of.getNode("KEY")) != null)
			sa.mKey = (String)on.getObject();
		if ((on = of.getNode("VALUE")) != null)
			sa.mValue = (String)on.getObject();
		if ((on = of.getNode("COPYBUFFER")) != null)
			sa.mCopyBuffer = Short.valueOf((String)on.getObject()).shortValue() > 0;
		return sa;
	}

	public SymbolAttribute getCopy() {
		SymbolAttribute sa = new SymbolAttribute();
		sa.mCopyBuffer = mCopyBuffer;
		sa.mKey = new String(mKey);
		sa.mValue = new String(mValue);
		return sa;
	}

	/**
	 * データの保存
	 * @param savename
	 */
	public void save(ObjectFolder savename) {
		if (savename == null)
				return;
		savename.setName("ATTRIBUTE");
		savename.addNode("KEY", mKey);
		savename.addNode("VALUE", mValue);
		savename.addNode("COPYBUFFER", mCopyBuffer);
	}

	public boolean isSetCopyBuffer() {
		return mCopyBuffer;
	}
}
