/*
 * Decompiled with CFR 0.152.
 */
package nethome5.ui;

import jp.kitec.lib.gui.event.AccelKey;
import jp.kitec.lib.kwt.KKeyEvent;
import nethome5.ui.CommandManager;
import nethome5.ui.ICanvas2D;
import nethome5.ui.command.Command;
import nethome5.ui.command.MultiCanvasCommand;

public class CanvasCommandDispatcher {
    protected Command mActiveCommand = null;
    protected Command mActiveMaskCommand = null;
    protected Command mArrowCommand = null;
    protected Command mViewControlCommand;
    protected Command mNullCommand = null;
    protected ICanvas2D mCanvas;
    private long clicktime = 0L;

    public CanvasCommandDispatcher(ICanvas2D can) {
        this.mCanvas = can;
    }

    public Command getActiveMaskCommand() {
        return this.mActiveMaskCommand;
    }

    public void clearMaskCommand() {
        this.mActiveMaskCommand = null;
    }

    public Command getMouseCommand() {
        return this.mActiveCommand;
    }

    public void setNullCommand(Command c) {
        this.mNullCommand = c;
        this.setMouseCommand(c);
    }

    public void setArrowKeyCommand(Command m) {
        this.mArrowCommand = m;
    }

    public void setViewControlCommand(Command c) {
        this.mViewControlCommand = c;
    }

    public Command getViewControlCommand() {
        return this.mViewControlCommand;
    }

    public void updateViewControl() {
        if (this.mViewControlCommand != null) {
            this.mViewControlCommand.updateInterface();
        }
    }

    public void setMouseCommand(Command c) {
        if (this.mActiveCommand != null) {
            this.mActiveCommand.end();
        }
        if (c == null) {
            this.mActiveCommand = this.mNullCommand;
            if (this.mNullCommand != null) {
                this.mNullCommand.updateInterface();
                this.mNullCommand.play();
            }
        } else {
            this.mActiveCommand = c;
        }
        if (this.mActiveCommand != null && this.mActiveCommand instanceof MultiCanvasCommand) {
            ((MultiCanvasCommand)this.mActiveCommand).setCurrentCanvas(this.mCanvas);
        }
        this.mCanvas.repaint();
    }

    public boolean mouseWheelUp(int x, int y, int modifiers) {
        if (this.mActiveMaskCommand != null && this.mActiveMaskCommand.wheelUp(x, y, modifiers)) {
            return true;
        }
        if (this.mActiveCommand != null && this.mActiveCommand.wheelDown(x, y, modifiers)) {
            return true;
        }
        return this.mViewControlCommand != null && this.mViewControlCommand.wheelUp(x, y, modifiers);
    }

    public boolean mouseWheelDown(int x, int y, int modifiers) {
        if (this.mActiveMaskCommand != null && this.mActiveMaskCommand.wheelDown(x, y, modifiers)) {
            return true;
        }
        if (this.mActiveCommand != null && this.mActiveCommand.wheelDown(x, y, modifiers)) {
            return true;
        }
        return this.mViewControlCommand != null && this.mViewControlCommand.wheelDown(x, y, modifiers);
    }

    public boolean mouseClicked(int x, int y, int modifiers) {
        this.mCanvas.updateCurrentMousePos(x, y, modifiers);
        if (this.mActiveMaskCommand != null) {
            return false;
        }
        long curtime = System.currentTimeMillis();
        long dur = curtime - this.clicktime;
        this.clicktime = curtime;
        if (dur < 300L && this.mActiveCommand != null) {
            return this.mActiveCommand.mouseDoubleClicked(x, y, modifiers);
        }
        return false;
    }

    public boolean mousePressed(int x, int y, int modifiers) {
        this.mCanvas.updateCurrentMousePos(x, y, modifiers);
        if (this.mActiveMaskCommand != null && this.mActiveMaskCommand.mousePress(x, y, modifiers)) {
            return true;
        }
        if (this.mActiveCommand != null && this.mActiveCommand.mousePress(x, y, modifiers)) {
            return true;
        }
        return this.mViewControlCommand != null && this.mViewControlCommand.mousePress(x, y, modifiers);
    }

    public boolean mouseReleased(int x, int y, int modifiers) {
        this.mCanvas.updateCurrentMousePos(x, y, modifiers);
        if (this.mActiveMaskCommand != null && this.mActiveMaskCommand.mouseRelease(x, y, modifiers)) {
            return true;
        }
        if (this.mActiveCommand != null && this.mActiveCommand.mouseRelease(x, y, modifiers)) {
            return true;
        }
        return this.mViewControlCommand != null && this.mViewControlCommand.mouseRelease(x, y, modifiers);
    }

    public boolean mouseDragged(int x, int y, int modifiers) {
        this.mCanvas.updateCurrentMousePos(x, y, modifiers);
        if (this.mActiveMaskCommand != null && this.mActiveMaskCommand.mouseDrag(x, y, modifiers)) {
            return true;
        }
        if (this.mActiveCommand != null && this.mActiveCommand.mouseDrag(x, y, modifiers)) {
            return true;
        }
        return this.mViewControlCommand != null && this.mViewControlCommand.mouseDrag(x, y, modifiers);
    }

    public boolean mouseMoved(int x, int y, int modifiers) {
        this.mCanvas.updateCurrentMousePos(x, y, modifiers);
        if (this.mActiveMaskCommand != null && this.mActiveMaskCommand.mouseMove(x, y, modifiers)) {
            return true;
        }
        if (this.mActiveCommand != null && this.mActiveCommand.mouseMove(x, y, modifiers)) {
            return true;
        }
        return this.mViewControlCommand != null && this.mViewControlCommand.mouseMove(x, y, modifiers);
    }

    public boolean mouseEntered(int x, int y, int modifiers) {
        this.mCanvas.updateCurrentMousePos(x, y, modifiers);
        if (this.mActiveMaskCommand != null && this.mActiveMaskCommand.mouseEntered(x, y, modifiers)) {
            return true;
        }
        if (this.mActiveCommand != null && this.mActiveCommand.mouseEntered(x, y, modifiers)) {
            return true;
        }
        return this.mViewControlCommand != null && this.mViewControlCommand.mouseEntered(x, y, modifiers);
    }

    public boolean mouseExited(int x, int y, int modifiers) {
        this.mCanvas.updateCurrentMousePos(x, y, modifiers);
        if (this.mActiveMaskCommand != null && this.mActiveMaskCommand.mouseExited(x, y, modifiers)) {
            return true;
        }
        if (this.mActiveCommand != null && this.mActiveCommand.mouseExited(x, y, modifiers)) {
            return true;
        }
        return this.mViewControlCommand != null && this.mViewControlCommand.mouseExited(x, y, modifiers);
    }

    public boolean keyPress(int keycode, int keymod) {
        CommandManager mc = CommandManager.getInstance();
        if (this.mActiveCommand != null && this.mActiveCommand.keyPress(keycode, keymod)) {
            return true;
        }
        if (this.mArrowCommand != null && (KKeyEvent.isMatchKey((int)keycode, (String)"UP") || KKeyEvent.isMatchKey((int)keycode, (String)"DOWN") || KKeyEvent.isMatchKey((int)keycode, (String)"LEFT") || KKeyEvent.isMatchKey((int)keycode, (String)"RIGHT") || KKeyEvent.isMatchKey((int)keycode, (String)"PAGE_UP") || KKeyEvent.isMatchKey((int)keycode, (String)"PAGE_DOWN") || KKeyEvent.isMatchKey((int)keycode, (String)"HOME")) && this.mArrowCommand.keyPress(keycode, keymod)) {
            return true;
        }
        AccelKey kc = mc.getAccel(keycode, keymod);
        if (kc != null) {
            ((Command)kc.getObject()).accelerate();
            if (this.mActiveCommand != null) {
                this.mActiveCommand.restoration();
            }
            if (this.mActiveMaskCommand != null) {
                this.mActiveMaskCommand.end();
                this.mActiveMaskCommand = null;
            }
            return true;
        }
        if (KKeyEvent.isMatchKey((int)keycode, (String)"ESCAPE")) {
            if (this.mActiveCommand != null) {
                this.mActiveCommand.restoration();
            }
            this.setMouseCommand(null);
            this.mCanvas.repaint();
            return true;
        }
        Command c = mc.getMaskCommand(keymod);
        if (c != this.mActiveMaskCommand) {
            if (this.mActiveMaskCommand != null) {
                this.mActiveMaskCommand.end();
            }
            this.mActiveMaskCommand = c;
            if (this.mActiveMaskCommand != null) {
                if (this.mActiveCommand != null) {
                    this.mActiveCommand.restoration();
                }
                this.mActiveMaskCommand.play();
                return true;
            }
        }
        return false;
    }

    public boolean keyRelease(int keycode, int keymod) {
        CommandManager mc = CommandManager.getInstance();
        if (this.mActiveMaskCommand != null) {
            this.mActiveMaskCommand.end();
            this.mActiveMaskCommand = null;
        }
        this.mActiveMaskCommand = mc.getMaskCommand(keymod);
        if (this.mActiveMaskCommand != null) {
            this.mActiveMaskCommand.play();
            return true;
        }
        if (this.mActiveCommand != null) {
            return this.mActiveCommand.keyReleased(keycode, keymod);
        }
        this.mCanvas.repaint();
        return false;
    }
}

