/*
 * Decompiled with CFR 0.152.
 */
package nethome.ui;

import java.util.ArrayList;
import java.util.List;
import jp.kitec.lib.gui.event.AccelKey;
import nethome.ui.MaskCommand;
import nethome.ui.command.Command;

public class CommandManager {
    private ArrayList<Command> mCommandCollection;
    private ArrayList<MaskCommand> mMaskCommands = new ArrayList();
    private ArrayList<AccelKey> mKeyCommand;

    public static CommandManager getInstance() {
        return CommandManagerHolder.mInstance;
    }

    public CommandManager() {
        this.mCommandCollection = new ArrayList();
        this.mKeyCommand = new ArrayList();
    }

    public void registerMaskEvent(Command m, int i) {
        this.mMaskCommands.add(new MaskCommand(m, i));
    }

    public Command getMaskCommand(int mod) {
        int size = this.mMaskCommands.size();
        for (int i = 0; i < size; ++i) {
            MaskCommand mc = this.mMaskCommands.get(i);
            if (!mc.isMatchMask(mod & 1 | mod & 8 | mod & 2)) continue;
            return mc.getCommand();
        }
        return null;
    }

    public List<Command> getCommandCollection() {
        return this.mCommandCollection;
    }

    public <T extends Command> T getCommand(Class<T> c) {
        for (int i = 0; i < this.mCommandCollection.size(); ++i) {
            Command com = this.mCommandCollection.get(i);
            if (!com.getClass().equals(c)) continue;
            return (T)((Command)c.cast(com));
        }
        return null;
    }

    public void initUserInterface() {
        for (int i = 0; i < this.mCommandCollection.size(); ++i) {
            Command cm = this.mCommandCollection.get(i);
            cm.initInterface();
        }
    }

    public void updateUserInterface() {
        int size = this.mCommandCollection.size();
        for (int i = 0; i < size; ++i) {
            Command cm = this.mCommandCollection.get(i);
            cm.updateInterface();
        }
    }

    public void registerAccel(AccelKey c) {
        this.mKeyCommand.add(c);
    }

    public AccelKey getAccel(int keycode, int modifires) {
        for (int i = 0; i < this.mKeyCommand.size(); ++i) {
            AccelKey kc = this.mKeyCommand.get(i);
            if (!kc.equal(modifires, keycode)) continue;
            return kc;
        }
        return null;
    }

    static class CommandManagerHolder {
        private static CommandManager mInstance = new CommandManager();

        CommandManagerHolder() {
        }
    }
}

