/*
 * Decompiled with CFR 0.152.
 */
package nethome5.util;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import jp.kitec.lib.util.UniqueNameUtil;
import nethome5.ui.MainApplicationCore;

public class NHFileServerRequester {
    public UniqueNameUtil.UniqueNameInfo createFile(MainApplicationCore app, String serverURL, Map<String, byte[]> commandData) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(bos);
        try {
            int size = commandData.size();
            out.writeInt(++size);
            this.writeString(out, "_compress");
            this.writeString(out, "1");
            for (Map.Entry<String, byte[]> e : commandData.entrySet()) {
                this.writeString(out, e.getKey());
                out.writeInt(e.getValue().length);
                out.write(e.getValue());
            }
            out.close();
            bos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        byte[] requestObject = bos.toByteArray();
        byte[] result = app.inquiry(serverURL, requestObject);
        try {
            if (result != null) {
                return UniqueNameUtil.createUniqueNameInfo((String)new String(result, "UTF-8"));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    protected void writeString(DataOutputStream out, String str) throws IOException {
        byte[] bytes = str.getBytes("UTF-8");
        out.writeInt(bytes.length);
        out.write(bytes);
    }

    public void openFile(MainApplicationCore app, String serverURL, UniqueNameUtil.UniqueNameInfo uniqueNameInfo) {
        if (uniqueNameInfo.path == null) {
            throw new NullPointerException();
        }
        this.openFile(app, serverURL, uniqueNameInfo.path);
    }

    public void openFile(MainApplicationCore app, String serverURL, String path) {
        app.openDocument(String.valueOf(serverURL) + "/" + path);
    }
}

