/*
 * Decompiled with CFR 0.152.
 */
package nethome5.ui;

import java.util.ArrayList;
import java.util.List;
import jp.kitec.lib.gui.event.AccelKey;
import nethome5.ui.MaskCommand;
import nethome5.ui.command.Command;

public class CommandManager {
    private ArrayList<Command> mCommandCollection;
    private ArrayList<MaskCommand> mMaskCommands = new ArrayList();
    private ArrayList<AccelKey> mKeyCommand;

    public static CommandManager getInstance() {
        return CommandManagerHolder.mInstance;
    }

    public CommandManager() {
        this.mCommandCollection = new ArrayList();
        this.mKeyCommand = new ArrayList();
    }

    public void registerMaskEvent(Command m, int i) {
        this.mMaskCommands.add(new MaskCommand(m, i));
    }

    public Command getMaskCommand(int mod) {
        int i = 0;
        int size = this.mMaskCommands.size();
        while (i < size) {
            MaskCommand mc = this.mMaskCommands.get(i);
            if (mc.isMatchMask(mod & 1 | mod & 8 | mod & 2)) {
                return mc.getCommand();
            }
            ++i;
        }
        return null;
    }

    public List<Command> getCommandCollection() {
        return this.mCommandCollection;
    }

    public <T extends Command> T getCommand(Class<T> c) {
        int i = 0;
        while (i < this.mCommandCollection.size()) {
            Command com = this.mCommandCollection.get(i);
            if (com.getClass().equals(c)) {
                return (T)((Command)c.cast(com));
            }
            ++i;
        }
        return null;
    }

    public void initUserInterface() {
        int i = 0;
        while (i < this.mCommandCollection.size()) {
            Command cm = this.mCommandCollection.get(i);
            cm.initInterface();
            ++i;
        }
    }

    public void updateUserInterface() {
        int i = 0;
        int size = this.mCommandCollection.size();
        while (i < size) {
            Command cm = this.mCommandCollection.get(i);
            cm.updateInterface();
            ++i;
        }
    }

    public void registerAccel(AccelKey c) {
        this.mKeyCommand.add(c);
    }

    public AccelKey getAccel(int keycode, int modifires) {
        int i = 0;
        while (i < this.mKeyCommand.size()) {
            AccelKey kc = this.mKeyCommand.get(i);
            if (kc.equal(modifires, keycode)) {
                return kc;
            }
            ++i;
        }
        return null;
    }

    static class CommandManagerHolder {
        private static CommandManager mInstance = new CommandManager();

        CommandManagerHolder() {
        }
    }
}

