/*
 * Decompiled with CFR 0.152.
 */
package nethome5.ui;

import java.awt.Container;
import java.util.ArrayList;
import java.util.List;
import nethome5.ui.ICanvas2D;
import nethome5.ui.gui.WindowContainer;
import nethome5.ui.gui.WindowSystemClient;

public class ProjectList {
    private ArrayList<WindowSystemClient> mList;
    private WindowSystemClient mActiveProject;
    private WindowContainer mCanvasContainer;

    public ProjectList(WindowContainer ct) {
        this.mCanvasContainer = ct;
        this.mList = new ArrayList();
    }

    public void addProjectList(WindowSystemClient prj) {
        if (!this.mList.contains(prj)) {
            this.mList.add(prj);
            if (this.mCanvasContainer != null) {
                this.mCanvasContainer.addChild(prj);
            }
            this.updateActive(prj);
        }
    }

    public WindowSystemClient getActiveProject() {
        return this.mActiveProject;
    }

    public WindowSystemClient setActiveProject(ICanvas2D can) {
        WindowSystemClient c = null;
        for (int i = 0; i < this.mList.size(); ++i) {
            WindowSystemClient f;
            WindowSystemClient o = this.mList.get(i);
            if (!(o instanceof WindowSystemClient) || (f = o).getCanvas() != can) continue;
            c = f;
            break;
        }
        if (c != null && c != this.mActiveProject) {
            this.updateActive(c);
            return this.mActiveProject;
        }
        return null;
    }

    private void updateActive(WindowSystemClient c) {
        if (this.mActiveProject != null) {
            this.mActiveProject.setActive(false);
        }
        this.mActiveProject = c;
        this.mActiveProject.setActive(true);
        if (this.mCanvasContainer != null) {
            this.mCanvasContainer.update(this.mActiveProject, false);
            this.mCanvasContainer.getContainer().validate();
        }
    }

    public void removeActiveProject() {
        WindowSystemClient active = this.getActiveProject();
        if (active != null && this.mCanvasContainer != null) {
            if (this.mList.contains(active)) {
                this.mList.remove(active);
            }
            this.mCanvasContainer.getContainer().remove((Container)((Object)active));
            this.mCanvasContainer.getContainer().validate();
        }
        if (this.mList.size() > 0) {
            WindowSystemClient o = this.mList.get(this.mList.size() - 1);
            if (o != null && o instanceof WindowSystemClient) {
                this.updateActive(o);
            }
        } else {
            this.mActiveProject = null;
        }
    }

    public void removeCanvasChild(WindowSystemClient c) {
        if (c == this.getActiveProject()) {
            this.removeActiveProject();
            return;
        }
        if (c != null && this.mCanvasContainer != null) {
            if (this.mList.contains(c)) {
                this.mList.remove(c);
            }
            this.mCanvasContainer.getContainer().remove(c.getComponent());
            this.mCanvasContainer.getContainer().validate();
        }
    }

    public List<WindowSystemClient> getList() {
        return this.mList;
    }
}

