/*
 * Decompiled with CFR 0.152.
 */
package nethome.ui;

import jp.kitec.kwt.KKeyEvent;
import jp.kitec.lib.gui.event.AccelKey;
import nethome.ui.CommandManager;
import nethome.ui.ICanvas2D;
import nethome.ui.command.Command;
import nethome.ui.command.MultiCanvasCommand;

public class CanvasCommandDispatcher {
    protected Command mActiveCommand = null;
    protected Command mActiveMaskCommand = null;
    protected Command mArrowCommand = null;
    protected Command mViewControlCommand;
    protected Command mNullCommand = null;
    protected ICanvas2D mCanvas;
    private long clicktime = 0L;

    public CanvasCommandDispatcher(ICanvas2D can) {
        this.mCanvas = can;
    }

    public Command getActiveMaskCommand() {
        return this.mActiveMaskCommand;
    }

    public void clearMaskCommand() {
        this.mActiveMaskCommand = null;
    }

    public Command getMouseCommand() {
        return this.mActiveCommand;
    }

    public void setNullCommand(Command c) {
        this.mNullCommand = c;
        this.setMouseCommand(c);
    }

    public void setArrowKeyCommand(Command m) {
        this.mArrowCommand = m;
    }

    public void setViewControlCommand(Command c) {
        this.mViewControlCommand = c;
    }

    public Command getViewControlCommand() {
        return this.mViewControlCommand;
    }

    public void updateViewControl() {
        if (this.mViewControlCommand != null) {
            this.mViewControlCommand.updateInterface();
        }
    }

    public void setMouseCommand(Command c) {
        if (this.mActiveCommand != null) {
            this.mActiveCommand.end();
        }
        if (c == null) {
            this.mActiveCommand = this.mNullCommand;
            if (this.mNullCommand != null) {
                this.mNullCommand.updateInterface();
                this.mNullCommand.play();
            }
        } else {
            this.mActiveCommand = c;
        }
        if (this.mActiveCommand != null && this.mActiveCommand instanceof MultiCanvasCommand) {
            ((MultiCanvasCommand)this.mActiveCommand).setCurrentCanvas(this.mCanvas);
        }
        this.mCanvas.repaint();
    }

    public void mouseWheelUp(int x, int y, int modifiers) {
        if (this.mViewControlCommand != null) {
            this.mViewControlCommand.wheelUp(x, y, modifiers);
        }
    }

    public void mouseWheelDown(int x, int y, int modifiers) {
        if (this.mViewControlCommand != null) {
            this.mViewControlCommand.wheelDown(x, y, modifiers);
        }
    }

    public void mouseClicked(int x, int y, int modifiers) {
        if (this.mActiveMaskCommand != null) {
            return;
        }
        this.mCanvas.updateCurrentMousePos(x, y, modifiers);
        if (this.mActiveMaskCommand != null) {
            return;
        }
        long curtime = System.currentTimeMillis();
        if (curtime - this.clicktime < 300L && this.mActiveCommand != null) {
            this.mActiveCommand.mouseDoubleClicked(x, y, modifiers);
        }
        this.clicktime = curtime;
    }

    public void mousePressed(int x, int y, int modifiers) {
        this.mCanvas.updateCurrentMousePos(x, y, modifiers);
        if (this.mActiveMaskCommand != null) {
            this.mActiveMaskCommand.mousePress(x, y, modifiers);
        } else if (this.mActiveCommand != null) {
            this.mActiveCommand.mousePress(x, y, modifiers);
        }
    }

    public void mouseReleased(int x, int y, int modifiers) {
        this.mCanvas.updateCurrentMousePos(x, y, modifiers);
        if (this.mActiveMaskCommand != null) {
            this.mActiveMaskCommand.mouseRelease(x, y, modifiers);
        } else if (this.mActiveCommand != null) {
            this.mActiveCommand.mouseRelease(x, y, modifiers);
        }
    }

    public void mouseDragged(int x, int y, int modifiers) {
        this.mCanvas.updateCurrentMousePos(x, y, modifiers);
        if (this.mActiveMaskCommand != null) {
            this.mActiveMaskCommand.mouseDrag(x, y, modifiers);
        } else if (this.mActiveCommand != null) {
            this.mActiveCommand.mouseDrag(x, y, modifiers);
        }
    }

    public void mouseMoved(int x, int y, int modifiers) {
        this.mCanvas.updateCurrentMousePos(x, y, modifiers);
        if (this.mActiveMaskCommand != null) {
            this.mActiveMaskCommand.mouseMove(x, y, modifiers);
        } else if (this.mActiveCommand != null) {
            this.mActiveCommand.mouseMove(x, y, modifiers);
        }
    }

    public void mouseEntered(int x, int y, int modifiers) {
        this.mCanvas.updateCurrentMousePos(x, y, modifiers);
        if (this.mActiveMaskCommand != null) {
            this.mActiveMaskCommand.mouseEntered(x, y, modifiers);
        } else if (this.mActiveCommand != null) {
            this.mActiveCommand.mouseEntered(x, y, modifiers);
        }
    }

    public void mouseExited(int x, int y, int modifiers) {
        this.mCanvas.updateCurrentMousePos(x, y, modifiers);
        if (this.mActiveMaskCommand != null) {
            this.mActiveMaskCommand.mouseExited(x, y, modifiers);
        } else if (this.mActiveCommand != null) {
            this.mActiveCommand.mouseExited(x, y, modifiers);
        }
    }

    public void keyPress(int keycode, int keymod) {
        CommandManager mc = CommandManager.getInstance();
        if (this.mActiveCommand != null && this.mActiveCommand.keyPress(keycode, keymod)) {
            return;
        }
        if (this.mArrowCommand != null && (KKeyEvent.isMatchKey((int)keycode, (String)"UP") || KKeyEvent.isMatchKey((int)keycode, (String)"DOWN") || KKeyEvent.isMatchKey((int)keycode, (String)"LEFT") || KKeyEvent.isMatchKey((int)keycode, (String)"RIGHT") || KKeyEvent.isMatchKey((int)keycode, (String)"PAGE_UP") || KKeyEvent.isMatchKey((int)keycode, (String)"PAGE_DOWN") || KKeyEvent.isMatchKey((int)keycode, (String)"HOME")) && this.mArrowCommand.keyPress(keycode, keymod)) {
            return;
        }
        AccelKey kc = mc.getAccel(keycode, keymod);
        if (kc != null) {
            ((Command)kc.getObject()).accelerate();
            if (this.mActiveCommand != null) {
                this.mActiveCommand.restoration();
            }
            if (this.mActiveMaskCommand != null) {
                this.mActiveMaskCommand.end();
                this.mActiveMaskCommand = null;
            }
            return;
        }
        if (KKeyEvent.isMatchKey((int)keycode, (String)"ESCAPE")) {
            if (this.mActiveCommand != null) {
                this.mActiveCommand.restoration();
            }
            this.setMouseCommand(null);
            this.mCanvas.repaint();
            return;
        }
        Command c = mc.getMaskCommand(keymod);
        if (c != this.mActiveMaskCommand) {
            if (this.mActiveMaskCommand != null) {
                this.mActiveMaskCommand.end();
            }
            this.mActiveMaskCommand = c;
            if (this.mActiveMaskCommand != null) {
                if (this.mActiveCommand != null) {
                    this.mActiveCommand.restoration();
                }
                this.mActiveMaskCommand.play();
            }
        }
    }

    public void keyRelease(int keycode, int keymod) {
        CommandManager mc = CommandManager.getInstance();
        if (this.mActiveMaskCommand != null) {
            this.mActiveMaskCommand.end();
            this.mActiveMaskCommand = null;
        }
        this.mActiveMaskCommand = mc.getMaskCommand(keymod);
        if (this.mActiveMaskCommand != null) {
            this.mActiveMaskCommand.play();
        } else if (this.mActiveCommand != null) {
            this.mActiveCommand.keyReleased(keycode, keymod);
        }
        this.mCanvas.repaint();
    }
}

