/*
 * Created on 2005/03/16
 */
package jp.kitec.lib.util;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

/**
 * String関係のユーティリティ
 *
 * @author kawae
 * @since 2005/03/16
 */
public class UtilString {

	/**
	 * タブをスペースに変更
	 *
	 * @param s
	 * @return
	 * @author kawae
	 * @since 2005/03/16
	 */
	public static String tab2space(String s) {
		if (s == null)
			return s;
		while (s.indexOf('\t') >= 0) {
			int index = s.indexOf('\t');
			int length = s.length();
			String s1 = s.substring(0, index);
			String s2 = (index  + 1) >= length ? "" :s.substring(index + 1);
			int s1length = 0;
			s1length = s1.length();
			for (int i = 0; i < s1.length(); i++) {
				char c = s1.charAt(i);
				if (!UtilString.isHankaku(c))
					s1length += 1;
			}
			int spacecount = 8 - s1length % 8;

			StringBuffer sb = new StringBuffer(s.length() + spacecount);
			sb.append(s1);
			for (int i = 0; i < spacecount; i++)
				sb.append(" ");
			sb.append(s2);
			s = sb.toString();
		}
		return s;
	}

	/**
	 * メッセージダイジェストの取得
	 * @param s
	 * @return
	 * @author kawae
	 * @since 2005/09/05
	 */
	public static String getMd5(String s) {
		if (s == null)
			return null;
		String str = null;
		try {
			StringBuffer sb = new StringBuffer();
			MessageDigest md = MessageDigest.getInstance("MD5");
			byte[] dat = s.getBytes();
			md.update(dat, 0, dat.length);
			byte[] ddata = md.digest();
			for (byte element : ddata) {
				int r = (element >= 0) ? element : (256 + element);
				if (r < 0x10)
					sb.append("0");
				sb.append(Integer.toHexString(r));
			}
			str = sb.toString();
		} catch (NoSuchAlgorithmException e) {
			throw new RuntimeException("MD5がサポートされていない", e);
		}
		return str;
	}


	/////////////////////////////////////////////////////////////////////////
	// 全角・半角関連

	/** 変換用の全角数字 */
	private static final char[] ZENKAKU_TABLE = {
		'０', '１', '２', '３', '４', '５', '６', '７', '８', '９'
	};

	/**
	 * 指定された半角数字の文字列を、全角数字の文字列へ変換する。
	 * 数字以外の場合、全角へは変換されず、もとの文字が設定される。
	 *
	 * @param str	半角数字の文字列
	 * @return 全角数字の文字列
	 * @since   2003/02/13
	 * @author  Kawae
	 * @version 2003/02/13
	 */
	public static String getZenkakuNumberExPeriod(String str) {
		char[] c = new char[str.length()];
		for (int i = 0; i < str.length(); i++) {
			char cc = str.charAt(i);
			if (cc >= '0' && cc <= '9') {
				c[i] = ZENKAKU_TABLE[cc - '0'];
			} else
				c[i] = cc;
		}
		return new String(c);
	}



	/**
	 * 半角か確認
	 * @param c
	 * @return
	 * @author kawae
	 * @since 2005/01/06
	 */
	public static boolean isHankaku(char c) {
		boolean hankaku = false;
		//半角カナか確認
		if (isHankakuKana(c))
			hankaku = true;
		else if (c < 0x7F)
			hankaku = true;
		return hankaku;
	}

	/**
	 * 半角カナか確認
	 * @param c
	 * @return
	 * @author kawae
	 * @since 2005/01/06
	 */
	public static boolean isHankakuKana(char c) {
	    return (c > 0xff60 && c <= 0xff9f);
	}

    /**
     * 全角カナか確認
     * @author kawae
     * @since 2005/01/06
     */
    public static boolean isZenkakuKana(char c) {
        return (c > 0x30a0 && c <= 0x30f4);
    }

    /**
     * 全角ひらがなか確認
     * @author kawae
     * @since 2005/01/06
     */
    public static boolean isFullHiraKana(char c) {
        return (c > 0x3040 && c <= 0x3094);
    }

	/**
	 * 半角数字か確認
	 * @param c
	 * @return
	 * @author kawae
	 * @since 2005/01/06
	 */
	public static boolean isHankakuSuuji(char c) {
		return c >= '0' && c <= '9';
	}

	/**
	 * 全角数字か確認
	 * @param c
	 * @return
	 * @author kawae
	 * @since 2005/01/06
	 */
	public static boolean isZenkakuSuuji(char c) {
		return c >= '０' && c <= '９';
	}


	/**
	 * 特定のエンコーディングで利用出来る文字か確認
	 *
	 * @param s
	 * @return
	 * @author kawae
	 * @since 2006/01/12
	 */
	public static boolean isEnableEncChar(char s, String enc) {
		return isEnableEncChar(Character.toString(s), enc);
	}

	/**
	 * 特定のエンコーディングで利用出来る文字か確認
	 *
	 * @param s
	 * @return
	 * @author kawae
	 * @since 2006/01/12
	 */
	public static boolean isEnableEncChar(String s, String enc) {
		try {
			String sjis = new String(s.getBytes(enc), enc);
			return s.equalsIgnoreCase(sjis);
		} catch (UnsupportedEncodingException expected) {
		}
		return false;
	}


	/////////////////////////////////////////////////////////////////////////
	// 比較関連

	/**
	 * 文字列が異なるか確認
	 * @param s1
	 * @param s2
	 * @return
	 * @author kawae
	 * @since 2004/09/26
	 */
	public static boolean isDiff(String s1, String s2) {
		return isDiff(s1, s2, false);
	}

	public static boolean isDiff(String s1, String s2, boolean compareUpperLower) {
		if ((s1 == null) != (s2 == null))
			return true;
		if (s1 == null)
			return false;

		if (compareUpperLower)
			return !s1.equals(s2);
		else
			return !s1.equalsIgnoreCase(s2);
	}

	/**
	 * 文字配列が異なるか確認
	 * @param s1
	 * @param s2
	 * @return
	 * @author kawae
	 * @since 2004/09/26
	 */
	public static boolean isDiff(String[] s1, String[] s2) {
		return isDiff(s1, s2, false);
	}

	public static boolean isDiff(String[] s1, String[] s2, boolean compareUpperLower) {
		if ((s1 == null) != (s2 == null))
			return true;
		if (s1 == null)
			return false;
		if (s1.length != s2.length)
			return true;
		for (int i = 0; i < s1.length; i++) {
			if (isDiff(s1[i], s2[i], compareUpperLower))
				return true;
		}
		return false;
	}

//	public static boolean isDiff(Color c1, Color c2) {
//		if ((c1 == null) != (c2 == null))
//			return true;
//		if (c1 == null)
//			return false;
//		return (c1.getRed() != c2.getRed() ||
//					c1.getGreen() != c2.getGreen() ||
//					c1.getBlue() != c2.getBlue());
//	}

	public static int bin2dec(String s) {
		int result = 0;
		for (int i = 0; i < s.length(); i++) {
			char c = s.charAt(s.length() - i - 1);
			if (c == '1')
				result |= 1 << i;
		}
		return result;
	}
}
