/*
 * Copyright (c) 2008 KITec Inc,.. All rights reserved.
 */
package jp.kitec.lib.util;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;



/**
 * 格納オブジェクトがnullでないことを保証する{@link List}。
 *
 * @author $Author$
 * @version $Revision$ $Date::                           $
 */
public class ListNotNullDecorator<E> implements List<E>, Serializable {

	private List<E> mList = null;

	public ListNotNullDecorator(List<E> list) {
		super();
		this.mList = list;
	}

	@Override
	public void add(int index, E element) {
		if (element == null) return;
		this.mList.add(index, element);
	}

	@Override
	public boolean add(E o) {
		if (o == null) return false;
		return this.mList.add(o);
	}

	@Override
	public boolean addAll(Collection<? extends E> c) {
		boolean result = false;
		if (c == null) return result;

		for (E element: c) {
			if (element == null) continue;
			this.mList.add(element);
			result = true;
		}
		return result;
	}

	@Override
	public boolean addAll(int index, Collection<? extends E> c) {
		return this.mList.addAll(index, c);
	}

	@Override
	public void clear() { this.mList.clear(); }
	@Override
	public boolean contains(Object o) { return this.mList.contains(o); }
	@Override
	public boolean containsAll(Collection<?> c) { return this.mList.containsAll(c); }
	@Override
	public boolean equals(Object o) { return this.mList.equals(o); }
	@Override
	public E get(int index) { return this.mList.get(index); }
	@Override
	public int hashCode() { return this.mList.hashCode(); }
	@Override
	public int indexOf(Object o) { return this.mList.indexOf(o); }
	@Override
	public boolean isEmpty() { return this.mList.isEmpty(); }
	@Override
	public Iterator<E> iterator() { return this.mList.iterator(); }
	@Override
	public int lastIndexOf(Object o) { return this.mList.lastIndexOf(o); }
	@Override
	public ListIterator<E> listIterator() { return this.mList.listIterator(); }
	@Override
	public ListIterator<E> listIterator(int index) { return this.mList.listIterator(index); }
	@Override
	public E remove(int index) { return this.mList.remove(index); }
	@Override
	public boolean remove(Object o) { return this.mList.remove(o); }
	@Override
	public boolean removeAll(Collection<?> c) { return this.mList.removeAll(c); }
	@Override
	public boolean retainAll(Collection<?> c) { return this.mList.retainAll(c); }
	@Override
	public E set(int index, E element) { return this.mList.set(index, element); }
	@Override
	public int size() { return this.mList.size(); }
	@Override
	public List<E> subList(int fromIndex, int toIndex) { return this.mList.subList(fromIndex, toIndex); }
	@Override
	public Object[] toArray() { return this.mList.toArray(); }
	@Override
	public <T> T[] toArray(T[] a) { return this.mList.toArray(a); }



} // end-interface
