/**
 *
 */
package jp.kitec.lib.geom;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import jp.kitec.lib.kwt.IRichGraphics;
import jp.kitec.lib.kwt.KPathIterator;

/**
 *
 * @since 2007/10/12
 * @author kamimura
 * @version 2007/10/12
 */
public class KPathSegmentUtil implements Serializable {
	private static final String TAG_MOVE = "m";
	private static final String TAG_LINE = "l";
	private static final String TAG_QUAD = "q";
	private static final String TAG_CUBE = "c";
	private static final String TAG_CLOSE = "z";
	/**
	 * コンストラクタ.
	 * @since 2007/10/12
	 * @author kamimura
	 */
	private KPathSegmentUtil() {
		super();
	}

	/**
	 * @param shape
	 * @param tokens
	 * @since 2007/10/12
	 * @author kamimura
	 * @version 2007/10/12
	 */
	public static List<KPath2d> read(String[] tokens){
		List<KPath2d> shape = new ArrayList<KPath2d>(tokens.length / 3);
		double[] points = new double[6];
		int pos = 0;
		int currType = 0;
		boolean found = false;
		for (String s : tokens){
			int type = getType(s);
			if(type==-1){
				try {
					points[pos] = Float.parseFloat(s);
				} catch (NumberFormatException e) {
					e.printStackTrace();
				}
				pos++;
			}else{
				if(found){
					if(currType!=IRichGraphics.DEF_SEG_CLOSE)
						shape.add(getPathSegment(currType, points));
				}
				found = true;
				pos = 0;
				currType = type;
				if(type==IRichGraphics.DEF_SEG_CLOSE)
					shape.add(getPathSegment(type, points));
			}
		}
		return shape;
	}

	/**
	 * @param shape
	 * @param tokens
	 * @since 2007/10/12
	 * @author kamimura
	 * @version 2007/10/12
	 */
	public static String[] write(List<KPath2d> segments){
		ArrayList<String> tokens = new ArrayList<String>(segments.size() * 7);
		double[] points = new double[6];
		for (KPath2d s : segments){
			tokens.add(getType(s.getType()));
			int n = 0;
			switch (s.getType()) {
			case IRichGraphics.DEF_SEG_CLOSE:
				n = 0;
				break;
			case IRichGraphics.DEF_SEG_MOVE:
			case IRichGraphics.DEF_SEG_LINE:
				n = 2;
				break;
			case IRichGraphics.DEF_SEG_QUAD:
				n = 4;
				break;
			case IRichGraphics.DEF_SEG_CUBIC:
				n = 6;
				break;
			}
			s.getPoints(points);
			for (int i = 0; i < n; i++) {
				tokens.add(Double.toString(points[i]));
			}
		}
		return tokens.toArray(new String[tokens.size()]);
	}

	private static int getType(String s){
		if(s==null)
			return -1;
		if(s.equals(TAG_MOVE))
			return IRichGraphics.DEF_SEG_MOVE;
		if(s.equals(TAG_LINE))
			return IRichGraphics.DEF_SEG_LINE;
		if(s.equals(TAG_QUAD))
			return IRichGraphics.DEF_SEG_QUAD;
		if(s.equals(TAG_CUBE))
			return IRichGraphics.DEF_SEG_CUBIC;
		if(s.equals(TAG_CLOSE))
			return IRichGraphics.DEF_SEG_CLOSE;
		return -1;
	}

	private static String getType(int n){
		switch (n) {
		case IRichGraphics.DEF_SEG_MOVE:
			return TAG_MOVE;
		case IRichGraphics.DEF_SEG_LINE:
			return TAG_LINE;
		case IRichGraphics.DEF_SEG_QUAD:
			return TAG_QUAD;
		case IRichGraphics.DEF_SEG_CUBIC:
			return TAG_CUBE;
		case IRichGraphics.DEF_SEG_CLOSE:
			return TAG_CLOSE;
		default:
			return null;
		}
	}

	/**
	 * @param type
	 * @param points
	 * @return
	 * @since 2007/10/12
	 * @author kamimura
	 * @version 2007/10/12
	 */
	public static KPath2d getPathSegment(int type, double[] points){
		switch (type) {
		case IRichGraphics.DEF_SEG_MOVE:
			return moveTo(points[0], points[1]);
		case IRichGraphics.DEF_SEG_LINE:
			return lineTo(points[0], points[1]);
		case IRichGraphics.DEF_SEG_CLOSE:
			return close();
		case IRichGraphics.DEF_SEG_QUAD:
			return quadTo(points[0], points[1], points[2], points[3]);
		case IRichGraphics.DEF_SEG_CUBIC:
			return cubicTo(points[0], points[1], points[2], points[3], points[4],  points[5]);
		}
		return null;
	}

	public static KPath2d moveTo(double x, double y){
		KPathMove2d path = new KPathMove2d();
		path.mX1 = x;
		path.mY1 = y;
		return path;
	}

	public static KPath2d lineTo(double x, double y){
		KPathLine2d path = new KPathLine2d();
		path.mX1 = x;
		path.mY1 = y;
		return path;
	}

	public static KPath2d close(){
		KPathClose2d path = new KPathClose2d();
		return path;
	}

	public static KPath2d quadTo(double cx1, double cy1, double x1, double y1){
		KPathQuad2d quad = new KPathQuad2d();
		quad.mCX1 = cx1;
		quad.mCY1 = cy1;
		quad.mX1 = x1;
		quad.mY1 = y1;
		return quad;
	}

	public static KPath2d cubicTo(double cx1, double cy1, double cx2, double cy2, double x1, double y1){
		KPathCubic2d cube = new KPathCubic2d();
		cube.mCX1 = cx1;
		cube.mCY1 = cy1;
		cube.mCX2 = cx2;
		cube.mCY2 = cy2;
		cube.mX1 = x1;
		cube.mY1 = y1;
		return cube;
	}

	public static KPathIterator iterator(final List<? extends KPath2d> shape, final int winding) {
		return new KPathIterator() {
			int pos = 0;

			@Override
			public boolean isDone() {
				return pos >= shape.size();
			}

			@Override
			public void next() {
				pos ++;
			}

			@Override
			public int getSegment(double[] coords) {
				KPath2d path = shape.get(pos);
				path.getPoints(coords);
				return path.getType();
			}

			@Override
			public int getWindingRule() {
				return winding;
			}
		};
	}
}
