package jp.kitec.lib.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Set;



/**
 * Connectionsクラス<br/>
 * JavaAPIでは提供していない、Hashtable/Propertiesに対するunmodifiableメソッドを提供します。<br/>
 */
public class KCollections {

	// ------------------------------------------------------------------
	// - コンストラクタ
	// ------------------------------------------------------------------

	/**
	 * コンストラクタ（new禁止）
	 */
	private KCollections() {
	}



	// ------------------------------------------------------------------
	// - メソッド
	// ------------------------------------------------------------------

	/**
	 * 指定されたコレクションの変更不可能なビューを返します。このメソッドを
	 * 使うと、モジュールはユーザに内部コレクションへの「読み取り専用」
	 * アクセス権を提供できます。返されたコレクションでのクエリーオペレーションは、
	 * 指定されたコレクションを直接読み取ります。直接かその反復子を使うかに
	 * 関係なく、返されたコレクションを変更しようとすると
	 * <tt>UnsupportedOperationException</tt> がスローされます。
	 * <p>
	 * 返されたコレクションは、hashCode オペレーションおよび equals オペレーショ
	 * ンを基となるコレクションに渡すことはなく、<tt>Object</tt> の <tt>equals</tt>
	 * メソッドおよび <tt>hashCode</tt> メソッドに依存します。これは、基と
	 * なるコレクションがセットまたはリストの場合にそれらのオペレーションの
	 * 規約を守るために必要です。
	 * <p>
	 * 返されたコレクションは、指定されたコレクションが直列化可能の場合は
	 * 直列化可能です。
	 *
	 * @param hashtable 変更不可能なビューが返されるコレクション
	 * @return 指定されたコレクションの変更不可能なビュー
	 */
	@SuppressWarnings("rawtypes")
	public static Hashtable unmodifiableHashtable(Hashtable hashtable) {
		return new UnmodifiableHashtable(hashtable);
	}

	@SuppressWarnings({"rawtypes", "unchecked"})
	public static class UnmodifiableHashtable extends Hashtable implements Map, Serializable {
		private Hashtable hashtable;

		public UnmodifiableHashtable(Hashtable hashtable) {
			if (hashtable == null) throw new NullPointerException();
			this.hashtable = hashtable;
		}

		@Override
		public Enumeration elements() {
			return Collections.enumeration(Collections.unmodifiableCollection(this.hashtable.values()));
		}
		@Override
		public Set entrySet() {
			return Collections.unmodifiableSet(this.hashtable.entrySet());
		}
		@Override
		public Enumeration keys() {
			return Collections.enumeration(Collections.unmodifiableSet(this.hashtable.keySet()));
		}
		@Override
		public Set keySet() {
			return Collections.unmodifiableSet(this.hashtable.keySet());
		}
		@Override
		public Collection values() {
			return Collections.unmodifiableCollection(this.hashtable.values());
		}

		@Override
		public void clear()                         { throw new UnsupportedOperationException(); }
		@Override
		public Object put(Object key, Object value) { throw new UnsupportedOperationException(); }
		@Override
		public void putAll(Map t)                   { throw new UnsupportedOperationException(); }
		@Override
		public Object remove(Object key)            { throw new UnsupportedOperationException(); }

		@Override
		public Object clone()                       { return super.clone();                       }
		@Override
		public boolean contains(Object value)       { return this.hashtable.contains(value);      }
		@Override
		public boolean containsKey(Object key)      { return this.hashtable.containsKey(key);     }
		@Override
		public boolean containsValue(Object value)  { return this.hashtable.containsValue(value); }
		@Override
		public boolean equals(Object o)             { return this.hashtable.equals(o);            }
		@Override
		public Object get(Object key)               { return this.hashtable.get(key);             }
		@Override
		public int hashCode()                       { return this.hashtable.hashCode();           }
		@Override
		public boolean isEmpty()                    { return this.hashtable.isEmpty();            }
		@Override
		public int size()                           { return this.hashtable.size();               }
		@Override
		public String toString()                    { return this.hashtable.toString();	          }
	}



	/**
	 * 指定されたコレクションの変更不可能なビューを返します。このメソッドを
	 * 使うと、モジュールはユーザに内部コレクションへの「読み取り専用」
	 * アクセス権を提供できます。返されたコレクションでのクエリーオペレーションは、
	 * 指定されたコレクションを直接読み取ります。直接かその反復子を使うかに
	 * 関係なく、返されたコレクションを変更しようとすると
	 * <tt>UnsupportedOperationException</tt> がスローされます。
	 * <p>
	 * 返されたコレクションは、hashCode オペレーションおよび equals オペレーショ
	 * ンを基となるコレクションに渡すことはなく、<tt>Object</tt> の <tt>equals</tt>
	 * メソッドおよび <tt>hashCode</tt> メソッドに依存します。これは、基と
	 * なるコレクションがセットまたはリストの場合にそれらのオペレーションの
	 * 規約を守るために必要です。
	 * <p>
	 * 返されたコレクションは、指定されたコレクションが直列化可能の場合は
	 * 直列化可能です。
	 *
	 * @param hashtable 変更不可能なビューが返されるコレクション
	 * @return 指定されたコレクションの変更不可能なビュー
	 */
	public static Properties unmodifiableProperties(Properties properties) {
		return new UnmodifiableProperties(properties);
	}

	@SuppressWarnings({"rawtypes", "unchecked"})
	public static class UnmodifiableProperties extends Properties implements Serializable {
		UnmodifiableHashtable unmodifiableHashtable;
		Properties properties;

		public UnmodifiableProperties(Properties properties) {
			if (properties == null) throw new NullPointerException();
			this.unmodifiableHashtable = new UnmodifiableHashtable(properties);
			this.properties = properties;
		}

		@Override
		public void clear()                         { this.unmodifiableHashtable.clear();                     }
		@Override
		public Object clone()                       { return super.clone();                                   }
		@Override
		public boolean contains(Object value)       { return this.unmodifiableHashtable.contains(value);      }
		@Override
		public boolean containsKey(Object key)      { return this.unmodifiableHashtable.containsKey(key);     }
		@Override
		public boolean containsValue(Object value)  { return this.unmodifiableHashtable.containsValue(value); }
		@Override
		public Enumeration elements()               { return this.unmodifiableHashtable.elements();           }
		@Override
		public Set entrySet()                       { return this.unmodifiableHashtable.entrySet();           }
		@Override
		public boolean equals(Object o)             { return this.unmodifiableHashtable.equals(o);            }
		@Override
		public Object get(Object key)               { return this.unmodifiableHashtable.get(key);             }
		@Override
		public int hashCode()                       { return this.unmodifiableHashtable.hashCode();           }
		@Override
		public boolean isEmpty()                    { return this.unmodifiableHashtable.isEmpty();            }
		@Override
		public Enumeration keys()                   { return this.unmodifiableHashtable.keys();               }
		@Override
		public Set keySet()                         { return this.unmodifiableHashtable.keySet();             }
		@Override
		public Object put(Object key, Object value) { return this.unmodifiableHashtable.put(key, value);      }
		@Override
		public void putAll(Map t)                   { this.unmodifiableHashtable.putAll(t);                   }
		@Override
		public Object remove(Object key)            { return this.unmodifiableHashtable.remove(key);          }
		@Override
		public int size()                           { return this.unmodifiableHashtable.size();               }
		@Override
		public String toString()                    { return this.unmodifiableHashtable.toString();           }
		@Override
		public Collection values()                  { return this.unmodifiableHashtable.values();             }

		@Override
		public void load(InputStream inStream)                     { throw new UnsupportedOperationException();             }
		@Override
		public Object setProperty(String key, String value)        { throw new UnsupportedOperationException();             }

		@Override
		public String getProperty(String key)                      { return this.properties.getProperty(key);               }
		@Override
		public String getProperty(String key, String defaultValue) { return this.properties.getProperty(key, defaultValue); }
		@Override
		public void list(PrintStream out)                          { this.properties.list(out);		                        }
		@Override
		public void list(PrintWriter out)                          { this.properties.list(out);		                        }
		@Override
	    @Deprecated
		public void save(OutputStream out, String header)          { this.properties.save(out, header);                     }
		@Override
		public void store(OutputStream out, String header) throws IOException { this.properties.store(out, header);         }
	}



} // end-class
