/**
 *
 */
package jp.kitec.lib.geom;

import jp.kitec.lib.kwt.IRichGraphics;
import jp.kitec.lib.kwt.KArea;


/**
 * パス構成要素
 * @since 2007/10/12
 * @author kamimura
 * @version 2007/10/12
 */
public class KPathMove2d extends KPath2d {

	/**
	 * コンストラクタ.
	 * @since 2007/10/12
	 * @author kamimura
	 */
	public KPathMove2d() {
	}

	/**
	 * @return the type
	 */
	@Override
	public int getType() {
		return IRichGraphics.DEF_SEG_MOVE;
	}

	@Override
	public int getNumberSize() {
		return 2;
	}

	/**
	 * @param d
	 * @param la
	 * @param shape
	 * @since 2007/10/12
	 * @author kamimura
	 * @version 2007/10/12
	 */
	@Override
	public void appendPath(IRichGraphics d, KLocalAxis la, KLocalAxis la2){
		double currx = mX1;
		double curry = mY1;

		if (la != null) {
			currx = la.getGlobalX(mX1, mY1);
			curry = la.getGlobalY(mX1, mY1);
		}
		d.pathMoveTo(currx, curry, la2);
	}

	/**
	 * @param points
	 * @since 2007/10/12
	 * @author kamimura
	 * @version 2007/10/12
	 */
	@Override
	public void getPoints(double[] points){
		points[0] = mX1;//mP1.x;
		points[1] = mY1;//mP1.y;
	}

	/**
	 * @param area
	 * @param x1
	 * @param y1
	 * @since 2007/10/12
	 * @author kamimura
	 * @version 2007/10/12
	 */
	@Override
	public void updateMinMax(KArea area, double x1, double y1){
		area.updateMinMax(mX1, mY1);
	}

	@Override
	public double distanceTo(double x, double y, double x1, double y1, int div) {
		return Double.POSITIVE_INFINITY;
	}
}
