/*
 * Copyright (c) 2009 KITec Inc,.. All rights reserved.
 */
package jp.kitec.lib.util;

import java.io.UnsupportedEncodingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import jp.kitec.lib.io.Base64Decoder;
import jp.kitec.lib.io.Base64Encoder;




/**
 * Base64ユーティリティ
 *
 * @author $Author: tanaka $
 * @version $Revision: 18 $ $Date:: 2009-12-10 14:19:42 +0900#$
 */
public class Base64Util {

	private static final Log log = LogFactory.getLog(Base64Util.class);

	/** デフォルトエンコーディング */
	private static final String DEFAULT_ENCODING = "MS932";



	/**
	 * コンストラクタ
	 */
	protected Base64Util() {
	}



	/**
	 * GZip圧縮、Base64変換を行う。
	 *
	 * @param org 変換対象データ
	 * @return GZip圧縮されBase64変換されたデータ文字列
	 */
	public static String encodeAndCompress(String org) {
		return encodeAndCompress(org, DEFAULT_ENCODING);
	}

	/**
	 * GZip圧縮、Base64変換を行う。
	 *
	 * @param org 変換対象データ
	 * @param encoding 文字エンコーディング
	 * @return GZip圧縮されBase64変換されたデータ文字列
	 */
	public static String encodeAndCompress(String org, String encoding) {
		byte[] strBytes = null;
		try {
			strBytes = org.getBytes(encoding);
		} catch (UnsupportedEncodingException e) {
			log.error("未サポート", e);
			return null;
		}

		byte[] comp = CompressData.compress(strBytes);
		return Base64Encoder.encode(comp);
	}

	/**
	 * Base64、GZip圧縮の展開を行う。
	 *
	 * @param b64 GZip圧縮されたBase64文字列
	 * @return 展開されたデータ文字列
	 */
	public static String decodeAndDecompress(String b64) {
		return decodeAndDecompress(b64, DEFAULT_ENCODING);
	}

	/**
	 * Base64、GZip圧縮の展開を行う。
	 *
	 * @param b64 GZip圧縮されたBase64文字列
	 * @param encoding 文字エンコーディング
	 * @return 展開されたデータ文字列
	 */
	public static String decodeAndDecompress(String b64, String encoding) {
		byte[] comp = Base64Decoder.decode(b64);
		Object org = CompressData.decompress(comp);

		String str = null;
		try {
			str = new String((byte[])org, encoding);
		} catch (UnsupportedEncodingException e) {
			log.error("未サポート", e);
			return null;
		}

		return str;
	}


} // end-class
