/*
 * Created on 2006/02/03
 */
package jp.kitec.lib.kwt;

/**
 * IRichGraphics用ユーティリティ
 * @author kawae
 * @since 2006/02/03
 */
public class RichGraphicsUtil {

	public static final float EPS = 1.0e-3f;
	/**
	 * 2点が同じ位置にあるか検査
	 * TODO:ToolMathと絡めて何処か他へ。
	 * @param p1x 点1のX座標
	 * @param p1y 点1のY座標
	 * @param p2x 点2のX座標
	 * @param p2y 点2のY座標
	 */
	public static boolean isSame2D(double p1x, double p1y, double p2x, double p2y) {
		if (Math.abs(p2x - p1x) < EPS && Math.abs(p2y - p1y) < EPS)
			return true;
		return false;
	}

	/**
	 * ２Dでの角度の計算
	 * TODO:ToolMathと絡めて何処か他へ。
	 * @param x1 点１のX座標
	 * @param y1 点１のY座標
	 * @param x2 点２のX座標
	 * @param y2 点２のY座標
	 * @return 角度（度）
	 */
	public static double getAngle2D(double x1, double y1, double x2, double y2) {
		double dx, dy, t, a;
		int area;

		dx = x2 - x1;
		dy = y2 - y1;

		if (dx >= 0.0) {
			if (dy >= 0.0)
				area = 0;
			else {
				area = 3;
				t = dx;
				dx = -dy;
				dy = t;
			}
		} else {
			if (dy >= 0.0) {
				area = 1;
				t = dx;
				dx = dy;
				dy = -t;
			} else {
				area = 2;
				dx = -dx;
				dy = -dy;
			}
		}

		if (dy > dx)
			a = Math.PI / 2.0f - Math.atan(dx / dy);
		else
			a = Math.atan(dy / dx);
		return (a + area * (Math.PI / 2.0)) * (180 / Math.PI);
	}

}
