/*
 * Copyright (c) 2011 KITec Inc,.. All rights reserved.
 */

package jp.kitec.lib.kwt;

import java.io.Serializable;

/**
 * @author kawae
 */
public abstract class KFont implements Serializable {
	private static final long serialVersionUID = 1L;

	/**
	 * フォントタイプ
	 */
	public static final int PLAIN = 0;
	public static final int BOLD = 1;
	public static final int ITALIC = 2;

	/**
	 * フォントオブジェクト
	 */
	private final String mFontname;
	private final int mFonttype;
	private final double mFontsize;

	protected KFont(String fontname, int fonttype, double fontsize) {
		mFontname = fontname;
		mFonttype = fonttype;
		mFontsize = fontsize;
	}

	public String getName() {
		return mFontname;
	}

	public int getStyle() {
		return mFonttype;
	}

	public double getSize() {
		return mFontsize;
	}

	public abstract KFontMetrics getFontMetrics(Object context);

	public abstract Object getFontObject();

	@Deprecated
	public double getAscent() {
		return getFontMetrics(null).getAscent();
	}

	@Deprecated
	public double getDescent() {
		return getFontMetrics(null).getDescent();
	}

	@Deprecated
	public double getHeight() {
		return getFontMetrics(null).getHeight();
	}

	@Deprecated
	public double stringWidth(String s) {
		return getFontMetrics(null).stringWidth(s);
	}

	/**
	 * 現在の Font オブジェクトを複製し新しいサイズを適用することにより、新しい Font オブジェクトを生成します。
	 * @param size
	 * @return
	 */
	public KFont deriveFont(double size) {
		return KRuntime.runtime().getFont(mFontname, mFonttype, size);
	}

	/** 
	 * 現在の Font オブジェクトを複製し新しいスタイルを適用することにより、新しい Font オブジェクトを生成します。 
	 * @param style
	 * @return
	 */
	public KFont deriveFont(int style) {
		return KRuntime.runtime().getFont(mFontname, style, mFontsize);
	}
	/**
	 * この Font オブジェクトを複製し新しいスタイルおよびサイズを適用することにより、新しい Font オブジェクトを生成します。
	 * @param style
	 * @param size
	 * @return
	 */
	public KFont deriveFont(int style, double size) {
		return KRuntime.runtime().getFont(mFontname, style, size);
	}
	
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((mFontname == null) ? 0 : mFontname.hashCode());
		result = prime * result + (int)mFontsize;
		result = prime * result + mFonttype;
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		KFont other = (KFont) obj;
		if (mFontname == null) {
			if (other.mFontname != null)
				return false;
		} else if (!mFontname.equals(other.mFontname))
			return false;
		if (Double.compare(mFontsize, other.mFontsize) != 0)
			return false;
		if (mFonttype != other.mFonttype)
			return false;
		return true;
	}

	public static KFont getFont(String fontname, int fontstyle, double fontsize) {
		return KRuntime.runtime().getFont(fontname, fontstyle, fontsize);
	}
}
