/*
 * Created on 2004/09/29
 */
package jp.kitec.lib.kwt;

import java.util.List;

import jp.kitec.lib.geom.K2DPathFigurePoint;
import jp.kitec.lib.geom.KLocalAxis;


/**
 * 描画インターフェース
 * @author kawae
 * @since 2004/09/29
 */
public interface IRichGraphics {
	/**　マーカー */
	public static final int MARK_CIR = 0;
	public static final int MARK_CIR_FILL = 1;
	public static final int MARK_REC = 2;
	public static final int MARK_REC_FILL = 3;
	public static final int MARK_CROS = 4;

	/** デバイスへの出力用のデフォルトの線種 */
	public static final KLineType LINE_1 = new KLineType("1", null, 1, KLineType.TYPE_DEVICE);
	public static final KLineType LINE_2 = new KLineType("2", null, 2, KLineType.TYPE_DEVICE);
	public static final KLineType LINE_3 = new KLineType("3", null, 3, KLineType.TYPE_DEVICE);

	public static final KLineType LINE_DASH_1 = new KLineType("1", new float[]{3, 3}, 1, KLineType.TYPE_DEVICE);

	public void clip(KPathIterator shape);

	/**
	 * 高クオリティモードの設定
	 * @param quality
	 */
	public void setQuality(boolean quality);

	/**
	 * クオリティモードの取得
	 * @return
	 */
	public boolean getQuality();

	public void setClipArea(double x1, double y1, double x2, double y2);
	public void releaseClipArea();

	public void setColor(KFill c);


	/**
	 * 現在の状態をスタックに保存
	 * 
	 * 保存される状態: クリップ領域 色
	 */
	public void save();

	/**
	 * スタックの末尾から状態を復元
	 */
	public void restore();

	public void drawLine(double x1, double y1, double x2, double y2, KLineType lt);
	public void drawCircle(double xc1, double yc1, double ra, double ss, double ee, KArcType type, KLineType lt);
	public void drawFillCircle(double xc1, double yc1, double ra, double ss, double ee, KArcType type, KLineType lt) ;
	public void drawEllipse(double xc1, double yc1, double v, double h, double ss, double ee, KArcType type, KLineType lt);
	public void drawFillEllipse(double xc1, double yc1, double v, double h, double ss, double ee, KArcType type, KLineType lt);
	public void drawRect(double x1, double y1, double x2, double y2, KLineType lt);
	public void drawFillRect(double x1, double y1, double x2, double y2, KLineType lt);
	public void drawRoundRect(double x1, double y1, double x2, double y2, double round, KLineType lt) ;
	public void drawFillRoundRect(double x1, double y1, double x2, double y2, double round, KLineType lt);
	public void drawPolygon(List<? extends K2DPathFigurePoint> poly, KLineType lt);
	public void drawFillPolygon(List<? extends K2DPathFigurePoint> poly, KLineType lt);
	public void drawPolyLine(List<? extends K2DPathFigurePoint> poly, KLineType lt);

	public void drawMark(double x, double y, int r, int type);

	/**
	 * イメージの描画
	 * イメージのIDを併用して描画する。
	 * @param img	イメージオブジェクト
	 * @param id	イメージファイルのID
	 * @param x1
	 * @param y1
	 * @param x2
	 * @param y2
	 * @author kawae
	 * @since 2004/10/27
	 */
	public void drawImage(KImage img, String id, double x1, double y1, double x2, double y2);
	public void drawImage(KImage img, String prefix, String id, double x1, double y1, double x2, double y2);
	public void drawImage(KImage img, double x1, double y1, double x2, double y2);
	public void drawImage(KImage img, double cx, double cy, double width, double height, double angle);
	public void drawText(String s, double x1, double y1, String fontname, int fonttype, double size, double angl);//, Color col);

	//パス関係
	/** 塗潰しルール（偶奇屈曲規則） */
	public static int WIND_EVEN_ODD = 0x1000;
	/** 塗潰しルール（非ゼロ屈曲規則） */
	public static int WIND_NON_ZERO = 0x2000;

	/** セグメントタイプ　ムーブ */
	public static final int DEF_SEG_MOVE = 0;
	/** セグメントタイプ　ライン */
	public static final int DEF_SEG_LINE = 1;
	/** セグメントタイプ　2 */
	public static final int DEF_SEG_QUAD = 2;
	/** セグメントタイプ　3 */
	public static final int DEF_SEG_CUBIC = 3;
	/** セグメントタイプ　クローズ */
	public static final int DEF_SEG_CLOSE = 4;

	/**
	 * パスの初期化
	 * @param i　塗潰しルール
	 * @author kawae
	 * @since 2006/01/18
	 */
	public void pathInit(int i);

	/**
	 * パスのクリア
	 *
	 * @author kawae
	 * @since 2006/01/18
	 */
	public void pathClear();

	/**
	 * パスの点移動
	 * @param x
	 * @param y
	 * @param la
	 * @author kawae
	 * @since 2006/01/18
	 */
	public void pathMoveTo(double x, double y, KLocalAxis la) ;

	/**
	 * ラインパスの追加
	 * @param x
	 * @param y
	 * @param la
	 * @author kawae
	 * @since 2006/01/18
	 */
	public void pathLineTo(double x, double y, KLocalAxis la);

	/**
	 *
	 * @param x1
	 * @param y1
	 * @param x2
	 * @param y2
	 * @param la
	 * @author kawae
	 * @since 2006/01/18
	 */
	public void pathQuadTo(double x1, double y1, double x2, double y2, KLocalAxis la);

	/**
	 * 最終点からベジェ曲線パスの追加
	 *
	 * @param x1
	 * @param y1
	 * @param x2
	 * @param y2
	 * @param x3
	 * @param y3
	 * @param la
	 * @author kawae
	 * @since 2006/01/18
	 */
	public void pathCurveTo(double x1, double y1, double x2, double y2, double x3, double y3, KLocalAxis la);

	/**
	 * パスを閉じる
	 *
	 * @author kawae
	 * @since 2006/01/18
	 */
	public void pathClose() ;

	/**
	 * パスの追加
	 * @param shape パス要素のコレクション
	 * @param la　ローカル座標
	 * @author kawae
	 * @since 2006/01/18
	 */
	public void pathAdd(KPathIterator shape, KLocalAxis la);


	/**
	 * ポリゴンの塗潰し
	 * @param lt 線タイプ
	 * @author kawae
	 * @since 2006/01/18
	 */
	public void fillPath(KLineType lt);


	/**
	 * パスの描画
	 * @param lt　線タイプ
	 * @author kawae
	 * @since 2006/01/18
	 */
	public void drawPath(KLineType lt);

	/**
	 * 円弧パスの追加
	 * 常に反時計廻りとするが、anglが負の場合は時計回り。
	 *
	 * @param xc　中心X座標
	 * @param yc　中心Y座標
	 * @param ra　半径
	 * @param ss　開始角度（度）
	 * @param ee　終了角度（度）
	 * @param la　ローカル座標
	 * @author kawae
	 * @since 2006/01/18
	 */
	public void pathArc(double xc, double yc, double ra, double startangl, double angl, KLocalAxis la);

	/**
	 * 実座標での描画範囲を返す。サポートしていない場合はnullを返す。
	 * @return
	 */
	public KArea getDrawArea();


	/**
	 * 単位長が何ドットになるかを返す。サポートしていない場合は0を返す。
	 * @return the dot/len
	 */
	public double getDotPerLen();
}


