/*
 * Created on 2004/10/14
 */
package jp.kitec.lib.util;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.Date;

/**
 *
 * 日付文字列ツール
 * @author kawae
 * @since 2004/10/14
 */
public class UtilDate {

	public static Calendar getTodayCalendar() {
		Calendar calendar = Calendar.getInstance();
		Date currentTime = new Date();
		calendar.setTime(currentTime);
		return calendar;
	}

	public static String getDate() {
//		Calendar calendar = Calendar.getInstance();
//		Date currentTime = new Date();
//		calendar.setTime(currentTime);
		return getDate(getTodayCalendar());
	}

	public static String getDate(Calendar calendar) {
		int year = calendar.get(Calendar.YEAR);
		int month =  (calendar.get(Calendar.MONTH)+1);
		int date =  calendar.get(Calendar.DATE);
		return getDate(year, month, date);
	}

	public static String getDate(int year, int month, int date) {
		NumberFormat formatter = new DecimalFormat("00");
		return year + "/" + formatter.format(month) + "/" + formatter.format(date);
	}


	public static long getTime(int year, int month, int day, int hour, int min, int sec) {
		Calendar calendar = Calendar.getInstance();
		calendar.set(year, month - 1, day, hour, min, sec);
		return calendar.getTimeInMillis();
	}

	/**
	 * 現在の年の取得
	 * @return
	 * @author kawae
	 * @since 2004/11/26
	 */
	public static String getYear() {
//		Calendar calendar = Calendar.getInstance();
//		Date currentTime = new Date();
//		calendar.setTime(currentTime);
//		NumberFormat formatter = new DecimalFormat("0000");
//		return formatter.format(calendar.get(Calendar.YEAR));
		return getYear(System.currentTimeMillis());
	}

	public static String getYear(long time) {
		Calendar calendar = Calendar.getInstance();
		calendar.setTimeInMillis(time);
		NumberFormat formatter = new DecimalFormat("0000");
		return formatter.format(calendar.get(Calendar.YEAR));
	}

	/**
	 * 現在の月の取得
	 * @return
	 * @author kawae
	 * @since 2004/11/26
	 */
	public static String getMonth() {
//		Calendar calendar = Calendar.getInstance();
//		Date currentTime = new Date();
//		calendar.setTime(currentTime);
//		NumberFormat formatter = new DecimalFormat("00");
//		return formatter.format((calendar.get(Calendar.MONTH)+1));
		return getMonth(System.currentTimeMillis());
	}
	public static String getMonth(long time) {
		Calendar calendar = Calendar.getInstance();
		calendar.setTimeInMillis(time);
		NumberFormat formatter = new DecimalFormat("00");
		return formatter.format((calendar.get(Calendar.MONTH)+1));
	}
	/**
	 * 現在の日の取得
	 * @return
	 * @author kawae
	 * @since 2004/11/26
	 */
	public static String getDay() {
//		Calendar calendar = Calendar.getInstance();
//		Date currentTime = new Date();
//		calendar.setTime(currentTime);
//		NumberFormat formatter = new DecimalFormat("00");
//		return formatter.format(calendar.get(Calendar.DATE));
		return getDay(System.currentTimeMillis());
	}
	public static String getDay(long time) {
		Calendar calendar = Calendar.getInstance();
		calendar.setTimeInMillis(time);
		NumberFormat formatter = new DecimalFormat("00");
		return formatter.format(calendar.get(Calendar.DATE));
	}


	/**
	 * 現在時刻の取得
	 * @return
	 * @author kawae
	 * @since 2004/11/26
	 */
	public static String getHour() {
//		Calendar calendar = Calendar.getInstance();
//		Date currentTime = new Date();
//		calendar.setTime(currentTime);
//		NumberFormat formatter = new DecimalFormat("00");
//		return formatter.format(calendar.get(Calendar.HOUR_OF_DAY));
		return getHour(System.currentTimeMillis());
	}
	public static String getHour(long time) {
		Calendar calendar = Calendar.getInstance();
		calendar.setTimeInMillis(time);
		NumberFormat formatter = new DecimalFormat("00");
		return formatter.format(calendar.get(Calendar.HOUR_OF_DAY));
	}

	/**
	 * 現在分の取得
	 * @return
	 * @author kawae
	 * @since 2004/11/26
	 */
	public static String getMin() {
//		Calendar calendar = Calendar.getInstance();
//		Date currentTime = new Date();
//		calendar.setTime(currentTime);
//		NumberFormat formatter = new DecimalFormat("00");
//		return formatter.format(calendar.get(Calendar.MINUTE));
		return getMin(System.currentTimeMillis());
	}
	public static String getMin(long time) {
		Calendar calendar = Calendar.getInstance();
		calendar.setTimeInMillis(time);
		NumberFormat formatter = new DecimalFormat("00");
		return formatter.format(calendar.get(Calendar.MINUTE));
	}

	/**
	 * 現在秒の取得
	 * @return
	 * @author kawae
	 * @since 2004/11/26
	 */
	public static String getSec() {
//		Calendar calendar = Calendar.getInstance();
//		Date currentTime = new Date();
//		calendar.setTime(currentTime);
//		NumberFormat formatter = new DecimalFormat("00");
//		return formatter.format(calendar.get(Calendar.SECOND));
		return getSec(System.currentTimeMillis());
	}
	public static String getSec(long time) {
		Calendar calendar = Calendar.getInstance();
		calendar.setTimeInMillis(time);
		NumberFormat formatter = new DecimalFormat("00");
		return formatter.format(calendar.get(Calendar.SECOND));
	}

	public static String getMiliSec() {
//		Calendar calendar = Calendar.getInstance();
//		Date currentTime = new Date();
//		calendar.setTime(currentTime);
//		NumberFormat formatter = new DecimalFormat("00");
//		return formatter.format(calendar.get(Calendar.SECOND));
		return getMiliSec(System.currentTimeMillis());
	}

	public static String getMiliSec(long time) {
		Calendar calendar = Calendar.getInstance();
		calendar.setTimeInMillis(time);
		NumberFormat formatter = new DecimalFormat("000");
		return formatter.format(calendar.get(Calendar.MILLISECOND));
	}

}
