package jp.kitec.lib.kwt;

public interface KPathIterator {
	/**
	 * 次のパスがあるかどうかを判定します
	 * @return
	 */
	boolean isDone();

	/**
	 * 次のパスに移動します
	 */
	void next();

	/**
	 * 現在のパスの座標をセットしタイプを返します
	 * @param coords
	 * @return
	 */
	int getSegment(double[] coords);
	
	/**
	 * 屈曲規則を返します。
	 * @return
	 */
	int getWindingRule();
}
