/*
 * 作成日: 2004/06/21
 *
 * この生成されたコメントの挿入されるテンプレートを変更するため
 * ウィンドウ > 設定 > Java > コード生成 > コードとコメント
 */
package jp.kitec.lib.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;


/**
 *
 * Base64でエンコードされたテキストを読み込み、デコードしバイト列を出力する
 *
 */
public class Base64Decoder {
	protected Base64Decoder() {
	}

	/**
	 * Base64エンコードされたテキストをバイナリに変換する。
	 * テキストには改行コード等含んでも可
	 * @param source Base64エンコードのテキスト
	 * @return byte[]
	 */
	public static byte[] decode(String source) {

		AbstFile af = new AbstFile();
		af.setData(source.getBytes());
		InputStream is = af.openInputStream();
		try {
			return decode( is );
		} catch (IOException e) {
			//起きないはず
			throw new IllegalStateException("内部エラー");
		} finally {
			try {
				is.close();
			} catch (IOException e) {
			}
		}
	}

	public static byte[] decode(InputStream pis) throws IOException {

		ByteArrayOutputStream bos = new ByteArrayOutputStream();
		byte[] base64 = new byte[4];

		while( get4bytes( pis , base64 ) ){
			bos.write( decode4bytes(base64) );
		}

		return bos.toByteArray();

	}

	private static boolean get4bytes(InputStream piss, byte[] t) throws IOException {
		boolean status = false;
		int data;

		for(int i=0;i<4;i++){
			do{
				data = piss.read();

				if(data == -1){
					return status;
				}
			}while(convert_array[data] == -1 && !(data == 61) );
			t[i] = (byte)data;
			status = true;
		}

		return status;
	}

	private static byte[] decode4bytes( byte[] source ){
		byte[] decoded;
		byte[] buffer = new byte[4];

		buffer[0] = convert_array[source[ 0 ]];
		buffer[1] = convert_array[source[ 1 ]];
		buffer[2] = convert_array[source[ 2 ]];
		buffer[3] = convert_array[source[ 3 ]];

		if ( buffer[2] == -1 && buffer[3] == -1){
			decoded = new byte[1];
			decoded[0] = (byte) ( buffer[0] << 2 & 0xfc | buffer[1] >>> 4 & 3 );
		}else if(buffer[2] !=  -1 && buffer[3] == -1){
			decoded = new byte[2];
			decoded[0] = (byte) ( buffer[0] << 2 & 0xfc | buffer[1] >>> 4 & 3 );
			decoded[1] = (byte) ( buffer[1] << 4 & 0xf0 | buffer[2] >>> 2 & 0xf);
		}else{
			decoded = new byte[3];
			decoded[0] = (byte) ( buffer[0] << 2 & 0xfc | buffer[1] >>> 4 & 3 );
			decoded[1] = (byte) ( buffer[1] << 4 & 0xf0 | buffer[2] >>> 2 & 0xf);
			decoded[2] = (byte) ( buffer[2] << 6 & 0xc0 | buffer[3] & 0x3f );
		}
		return decoded;
	}

	private static final char translation_array[] = {
		'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J',
		'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T',
		'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd',
		'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n',
		'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x',
		'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7',
		'8', '9', '+', '/'
	};

	private static final byte convert_array[];

	static
	{
		convert_array = new byte[256];
		for(int i = 0; i < 255; i++){
			convert_array[i] = -1;
		}

		for(int j = 0; j < translation_array.length; j++){
			convert_array[translation_array[j]] = (byte)j;
		}
	}

}
