/**
 *
 */
package jp.kitec.lib.geom;

import java.io.Serializable;

import jp.kitec.lib.kwt.IRichGraphics;
import jp.kitec.lib.kwt.KArea;
import jp.kitec.lib.util.MathUtil;

/**
 * パス構成要素
 * 
 * @since 2007/10/12
 * @author kamimura
 * @version 2007/10/12
 */
public abstract class KPath2d implements Serializable {
	/** 点1 */
	protected double mX1, mY1;

	/**
	 * コンストラクタ.
	 * 
	 * @since 2007/10/12
	 * @author kamimura
	 */
	public KPath2d() {
	}

	/**
	 * @return the x1
	 */
	public double getX1() {
		return mX1;
	}

	/**
	 * @return the y1
	 */
	public double getY1() {
		return mY1;
	}

	/**
	 * パラメーターtでのX座標を返す
	 * @param x1
	 * @param t
	 * @return
	 */
	public double getX(double x1, double t) {
		return x1;
	}

	/**
	 * パラメーターtでのY座標を返す
	 * @param y1
	 * @param t
	 * @return
	 */
	public double getY(double y1, double t) {
		return y1;
	}

	/**
	 * @return the type
	 */
	public abstract int getType();

	/**
	 * @return
	 * @since 2009/11/06
	 * @version 2009/11/06
	 */
	public abstract int getNumberSize();

	/**
	 * @param d
	 * @param la
	 * @param shape
	 * @since 2007/10/12
	 * @author kamimura
	 * @version 2007/10/12
	 */
	public abstract void appendPath(IRichGraphics d, KLocalAxis la,
			KLocalAxis la2);

	/**
	 * @param points
	 * @since 2007/10/12
	 * @author kamimura
	 * @version 2007/10/12
	 */
	public void getPoints(double[] points) {
	}

	/**
	 * @param area
	 * @param x1
	 * @param y1
	 * @since 2007/10/12
	 * @author kamimura
	 * @version 2007/10/12
	 */
	public abstract void updateMinMax(KArea area, double x1, double y1);

	/**
	 * パスの指定された分割数の直線近似から指定された点までの距離を返す
	 * @param x1
	 * @param y1
	 * @param div
	 * @return
	 */
	public double distanceTo(double x, double y, double x1, double y1, int div) {
		if (div < 2)
			return MathUtil.getLengthLineSegmentToPoint2D(x, y, x1, y1, mX1, mY1);

		double len = Double.POSITIVE_INFINITY;
		double delta = 1.0 / div;
		double cx = x1;
		double cy = y1;
		for (int i = 0; i <= div; i++) {
			double t = i * delta;
			double nx = getX(x1, t);
			double ny = getY(y1, t);
			len = Math.min(len, MathUtil.getLengthLineSegmentToPoint2D(x, y, cx, cy, nx, ny));
			cx = nx;
			cy = ny;
		}
		return len;
	}
}
