/*
 * Copyright (c) 2011 KITec Inc,.. All rights reserved.
 * @author matsuzaki
 */
/**
 *
 */
package jp.kitec.vecmath;

import java.io.Serializable;

import javax.vecmath.Point2d;

/**
 * @author matsuzaki
 *
 */
public class KLine2d implements Serializable {
	/** 端点1 */
	public Point2d pA;

	/** 端点2 */
	public Point2d pB;

	/**
	 * コンストラクタ
	 */
	public KLine2d() {
		this(new Point2d(), new Point2d());
	}

	/**
	 * コンストラクタ
	 */
	public KLine2d(Point2d p1, Point2d p2) {
		pA = p1;
		pB = p2;
	}

	/**
	 * コンストラクタ
	 * @param x1
	 * @param y1
	 * @param x2
	 * @param y2
	 */
	public KLine2d(double x1, double y1, double x2, double y2) {
		this(new Point2d(x1, y1), new Point2d(x2, y2));
	}
}
