/*
 * Copyright (c) 2012 KITec Inc,.. All rights reserved.
 */
package jp.kitec.lib.geom;

/**
 * ベジェ曲線要素のインターフェース
 * 
 * @author matsuzaki
 */
public interface K2DPathFigureCurve extends K2DPathFigureLine {
	/**
	 * 制御点のX座標値を取得する。
	 * 
	 * @return 制御点のX座標値
	 */
	public double getCX1();

	/**
	 * 制御点のY座標値を取得する。
	 * 
	 * @return 制御点のY座標値
	 */
	public double getCY1();

	/**
	 * 制御点のX座標値を取得する。
	 * 
	 * @return 制御点のX座標値
	 */
	public double getCX2();

	/**
	 * 制御点のY座標値を取得する。
	 * 
	 * @return 制御点のY座標値
	 */
	public double getCY2();

	/**
	 * 制御点のX座標値をセットする。
	 * 
	 * @param x
	 *            制御点のX座標値
	 */
	public void setCX1(double x);

	/**
	 * 制御点のY座標値をセットする。
	 * 
	 * @param y
	 *            円弧の中心点のＹ座標値
	 */
	public void setCY1(double y);

	/**
	 * 制御点のX座標値をセットする。
	 * 
	 * @param x
	 *            制御点のX座標値
	 */
	public void setCX2(double x);

	/**
	 * 制御点のY座標値をセットする。
	 * 
	 * @param y
	 *            円弧の中心点のＹ座標値
	 */
	public void setCY2(double y);

}
