/*
 * Copyright (c) 2008-2010 KITec Inc,.. All rights reserved.
 */
package jp.kitec.lib.util;

import org.apache.commons.lang.builder.ToStringBuilder;



/**
 * 2つの値の組
 *
 * @author $Author$
 * @version $Revision$ $Date::                           $
 *
 * @param <T1> 1番目の値の型
 * @param <T2> 2番目の値の型
 */
public class Tuple<T1, T2> {

	/** 1番目の値 */
	public T1 value1;

	/** 2番目の値 */
	public T2 value2;



	/**
	 * 2つの値の組を作成して返します。
	 *
	 * @param <T1> 1番目の値の型
	 * @param <T2> 2番目の値の型
	 * @return 2つの値の組
	 */
	public static <T1, T2> Tuple<T1, T2> newInstance() {
		return new Tuple<T1, T2>();
	}

	/**
	 * 2つの値の組を作成して返します。
	 *
	 * @param <T1> 1番目の値の型
	 * @param <T2> 2番目の値の型
	 * @param value1 1番目の値
	 * @param value2 2番目の値
	 * @return 2つの値の組
	 */
	public static <T1, T2> Tuple<T1, T2> newInstance(final T1 value1, final T2 value2) {
		return new Tuple<T1, T2>(value1, value2);
	}

	/**
	 * インスタンスを構築します。
	 */
	public Tuple() {
	}

	/**
	 * インスタンスを構築します。
	 *
	 * @param value1 1番目の値
	 * @param value2 2番目の値
	 */
	public Tuple(final T1 value1, final T2 value2) {
		this.value1 = value1;
		this.value2 = value2;
	}

	@Override
	public String toString() {
		return new ToStringBuilder(this)
			.append(this.value1)
			.append(this.value2)
			.toString();
	}



} // end-class
