/*
 * Created on 2006/01/13
 */
package jp.kitec.lib.util;


/**
 * パス
 * @author kawae
 * @since 2006/01/13
 */
public interface KCollection<E> {
	/**
	 * 要素のサイズの取得
	 * @return
	 * @author kawae
	 * @since 2006/01/13
	 */
	public int size();

	/**
	 * この RefList の先頭の要素を返す。
	 *
	 * @return 先頭の要素
	 * @since   2002/12/20
	 * @author  Kawae
	 * @version 2002/12/20
	 */
	public E firstElement();

	/**
	 * この RefList の最後の要素を返す。
	 *
	 * @return 最後の要素
	 * @since   2002/12/20
	 * @author  Kawae
	 * @version 2002/12/20
	 */
	public E lastElement();

	/**
	 * n番目の要素の取得
	 *
	 * @param i
	 * @return
	 * @author kawae
	 * @since 2006/01/13
	 */
	public E elementAt(int i);

}
