package jp.kitec.kwt;

import java.io.Serializable;


public class KRadialGradientFill extends KGradientFill implements Serializable {
	private double mCenterX, mCenterY;
	private double mFocusX, mFocusY;
	private double mRadius;

	public KRadialGradientFill(double cx, double cy, double radius,
			double[] fractions, KColor[] color) {
		super(color, fractions);
		mCenterX = mFocusX = cx;
		mCenterY = mFocusY = cy;
		mRadius = radius;
	}

	public KRadialGradientFill(double centerX, double centerY, double radius, double focusX, double focusY,
			double[] fractions, KColor[] color) {
		super(color, fractions);
		mCenterX = centerX;
		mCenterY = centerY;
		mFocusX = focusX;
		mFocusY = focusY;
		mRadius = radius;
	}

	public double getCenterX() {
		return mCenterX;
	}

	public double getCenterY() {
		return mCenterY;
	}

	public double getFocusX() {
		return mFocusX;
	}

	public double getFocusY() {
		return mFocusY;
	}

	public double getRadius() {
		return mRadius;
	}

	@Override
	public String encode() {
		StringBuilder sb = new StringBuilder(super.encode());
		sb.append(";");
		sb.append(mCenterX);
		sb.append(";");
		sb.append(mCenterY);
		sb.append(";");
		sb.append(mFocusX);
		sb.append(";");
		sb.append(mFocusY);
		sb.append(";");
		sb.append(mRadius);
		return sb.toString();
	}

	public static KRadialGradientFill decode(String val) {
		KRadialGradientFill grad = new KRadialGradientFill(0, 0, 0, 0, 0, new double[0], new KColor[0]);
		String[] tokens = val.split(";");
		if (tokens.length != 7)
			throw new IllegalArgumentException();
		KGradientFill.decodeGradient(val, grad);
		grad.mCenterX = Double.parseDouble(tokens[2]);
		grad.mCenterY = Double.parseDouble(tokens[3]);
		grad.mFocusX = Double.parseDouble(tokens[4]);
		grad.mFocusY = Double.parseDouble(tokens[5]);
		grad.mRadius = Double.parseDouble(tokens[6]);
		return grad;
	}
}