package jp.kitec.kwt;

import java.io.Serializable;


public abstract class KGradientFill implements KFill, Serializable {
	private KColor[] mColor;
	private double[] mFractions;

	protected KGradientFill(KColor[] color, double[] fractions) {
		if (color.length != fractions .length)
			throw new IllegalArgumentException();
		mColor = color;
		mFractions = fractions;
	}

	public KColor[] getColor() {
		return mColor;
	}

	public double[] getFractions() {
		return mFractions;
	}

	@Override
	public String encode() {
		StringBuilder sb = new StringBuilder();
		for (int i = 0; i < mColor.length; i++) {
			if (i != 0)
				sb.append(",");
			sb.append(mColor[i].encode());
		}
		sb.append(";");
		for (int i = 0; i < mFractions.length; i++) {
			if (i != 0)
				sb.append(",");
			sb.append(mFractions[i]);
		}
		return sb.toString();
	}

	public static void decodeGradient(String val, KGradientFill grad) {
		String[] tokens = val.split(";");
		if (tokens.length < 2)
			throw new IllegalArgumentException();
		String[] colors = tokens[0].split(",");
		String[] fractions = tokens[1].split(",");
		if (colors.length != fractions.length)
			throw new IllegalArgumentException();
		grad.mColor = new KColor[colors.length];
		grad.mFractions = new double[colors.length];

		for (int i = 0; i < colors.length; i++) {
			grad.mColor[i] = KColor.decode(colors[i]);
			grad.mFractions[i] = Double.parseDouble(fractions[i]);
		}
	}
}