/*
 * Copyright (c) 2011 KITec Inc,.. All rights reserved.
 */

package jp.kitec.kwt;

import java.io.Serializable;

import jp.kitec.lib.util.tree.ObjectFolder;
import jp.kitec.lib.util.tree.ObjectNode;

public class KDimension implements Serializable, Cloneable {
	private static final long serialVersionUID = 1L;
	public static final String GEOMNAME = "DIMENSION";

	public int width;
	public int height;

	public KDimension() {
	}

	public KDimension(int width, int height) {
		this.width = width;
		this.height = height;
	}

	public KDimension(KDimension dim) {
		this.width = dim.width;
		this.height = dim.height;
	}

	public void set(KDimension dim) {
		this.width = dim.width;
		this.height = dim.height;
	}

	public KDimension clone() {
		try {
			return (KDimension)super.clone();
		} catch (CloneNotSupportedException e) {
			throw new InternalError();
		}
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + height;
		result = prime * result + width;
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		KDimension other = (KDimension) obj;
		if (height != other.height)
			return false;
		if (width != other.width)
			return false;
		return true;
	}

	public void save(ObjectFolder savenode) {
		savenode.setName(GEOMNAME);
		ObjectFolder.addNodeInt(savenode, "w", width);
		ObjectFolder.addNodeInt(savenode, "h", height);
	}

	public static void readData(ObjectFolder datanode, KDimension r) {
		ObjectNode on;
		if ((on = datanode.getNode("w")) != null)
			r.width = on.getInt(0);
		if ((on = datanode.getNode("h")) != null)
			r.height = on.getInt(0);
	}
}
