package jp.kitec.kwt;

import java.io.Serializable;


/**
 * キャンバス等のビューポート
 */

public class KViewPort implements Serializable {
	private static final long serialVersionUID = 1L;

	/** ビューの名前 */
	private String mViewName;

	/** ビューの最大・最小 */
	private double x1, y1, x2, y2;

	/**
	 * コンストラクタ
	 */
	public KViewPort() {
		this("");
	}

	/**
	 * コンストラクタ
	 * @param viewname
	 * @author kawae
	 * @since 2004/10/02
	 */
	public KViewPort(String viewname) {
		x1 = y1 = x2 = y2 = 0;
		mViewName = viewname;
	}

	/**
	 * ビューの名前の設定
	 * @param s
	 * @author kawae
	 * @since 2004/10/02
	 */
	public void setViewPortName(String s) {
		mViewName = s;
	}

	/**
	 * ビューの名前の取得
	 * @return
	 * @author kawae
	 * @since 2004/10/02
	 */
	public String getViewPortName() {
		return mViewName;
	}

	public double getX1() {
		return x1;
	}

	public void setX1(double x1) {
		this.x1 = x1;
	}

	public double getY1() {
		return y1;
	}

	public void setY1(double y1) {
		this.y1 = y1;
	}

	public double getX2() {
		return x2;
	}

	public void setX2(double x2) {
		this.x2 = x2;
	}

	public double getY2() {
		return y2;
	}

	public void setY2(double y2) {
		this.y2 = y2;
	}

	/** 表示中心 */
	public double getCx() {
		return (x1 + x2) / 2;
	}

	public double getCy() {
		return (y1 + y2) / 2;
	}

	public KViewPort getCopy() {
		KViewPort vp = new KViewPort(mViewName);
		vp.x1 = x1;
		vp.y1 = y1;
		vp.x2 = x2;
		vp.y2 = y2;
		return vp;
	}

	public void setViewPort(KViewPort vp) {
		x1 = vp.x1;
		y1 = vp.y1;
		x2 = vp.x2;
		y2 = vp.y2;
	}

	public void resetViewPort(KArea area, double margin) {
		x1 = area.minX - margin;
		y1 = area.minY - margin;
		x2 = area.maxX + margin;
		y2 = area.maxY + margin;
	}

	public void resetViewPort(double minx, double miny, double maxx, double maxy, double margin) {
		x1 = minx - margin;
		y1 = miny - margin;
		x2 = maxx + margin;
		y2 = maxy + margin;
	}

	/**
	 * 画面中心の移動
	 * @param cx
	 * @param cy
	 */
	 public void setViewCenter(double cx, double cy) {
		double offsetx = cx - getCx();
		double offsety = cy - getCy();
		x1 += offsetx;
		x2 += offsetx;
		y1 += offsety;
		y2 += offsety;
	 }

	 public double dotPerLen(KDimension d) {
		 double ww = d.width / (((x2 - x1)));
		 double wh = d.height / (((y2 - y1)));
		 return ww < wh ? ww : wh;
	 }


	 /**
	  * 実座標から画面座標へ（ｘ）
	  *
	  * @param   d   画面サイズ
	  * @param   x   実座標値
	  * @return  デバイス座標値
	  */
	 public int realToDevX(KDimension d, double x) {
		 return (int)Math.round(realToDevXd(d, x));
	 }

	 /**
	  * 実座標から画面座標へ（ｙ）
	  *
	  * @param   d   画面サイズ
	  * @param   y   実座標値
	  * @return  デバイス座標値
	  */
	 public int realToDevY(KDimension d, double y) {
		 return (int)Math.round(realToDevYd(d, y));
	 }

	 /**
	  * 実座標から画面座標へ（ｘ）
	  *
	  * @param   d   画面サイズ
	  * @param   x   実座標値
	  * @return  デバイス座標値
	  */
	 public double realToDevXd(KDimension d, double x) {
		 return (x - getCx()) * dotPerLen(d) + d.width / 2d;
	 }

	 /**
	  * 実座標から画面座標へ（ｙ）
	  *
	  * @param   d   画面サイズ
	  * @param   y   実座標値
	  * @return  デバイス座標値
	  */
	 public double realToDevYd(KDimension d, double y) {
		 return d.height - ((y - getCy()) * dotPerLen(d) + d.height / 2d);
	 }

	 /**
	  * 画面座標から実座標へ（ｘ）
	  *
	  * @param   d   画面サイズ
	  * @param   x   デバイス座標値
	  * @return      実座標値
	  */
	 public double devToRealX(KDimension d, double x) {
		 return ((x - d.width / 2d) / dotPerLen(d) + getCx());
	 }

	 /**
	  * 画面座標から実座標へ（ｙ）
	  *
	  * @param   d   画面サイズ
	  * @param   y   デバイス座標値
	  * @return      実座標値
	  */
	 public double devToRealY(KDimension d, double y) {
		 return ((d.height / 2d - y) / dotPerLen(d) + getCy());
	 }
}
