package jp.kitec.kwt;

import java.io.Serializable;


public class KLinearGradientFill extends KGradientFill implements Serializable {
	private double mStartX, mStartY;
	private double mEndX, mEndY;

	public KLinearGradientFill(double startX, double startY, double endX, double endY,
			double[] fractions, KColor[] color) {
		super(color, fractions);
		mStartX = startX;
		mStartY = startY;
		mEndX = endX;
		mEndY = endY;
	}

	public double getStartX() {
		return mStartX;
	}

	public double getStartY() {
		return mStartY;
	}

	public double getEndX() {
		return mEndX;
	}

	public double getEndY() {
		return mEndY;
	}

	@Override
	public String encode() {
		StringBuilder sb = new StringBuilder(super.encode());
		sb.append(";");
		sb.append(mStartX);
		sb.append(";");
		sb.append(mStartY);
		sb.append(";");
		sb.append(mEndX);
		sb.append(";");
		sb.append(mEndY);
		return sb.toString();
	}

	public static KLinearGradientFill decode(String val) {
		KLinearGradientFill grad = new KLinearGradientFill(0, 0, 0, 0, new double[0], new KColor[0]);
		String[] tokens = val.split(";");
		if (tokens.length != 6)
			throw new IllegalArgumentException();
		KGradientFill.decodeGradient(val, grad);
		grad.mStartX = Double.parseDouble(tokens[2]);
		grad.mStartY = Double.parseDouble(tokens[3]);
		grad.mEndX = Double.parseDouble(tokens[4]);
		grad.mEndY = Double.parseDouble(tokens[5]);
		return grad;
	}
}