package jp.kitec.kwt;

public class KFills {

	public static String encode(KFill f) {
		if (f == null)
			return "";
		if (f instanceof KColor)
			return f.encode();
		if (f instanceof KLinearGradientFill)
			return "l:" + f.encode();
		if (f instanceof KRadialGradientFill)
			return "r:" + f.encode();
		throw new IllegalArgumentException("unknown class " + f.getClass());
	}

	public static KFill decode(String str) {
		if (str == null || str.length() == 0)
			return null;
		if (str.startsWith("#"))
			return KColor.decode(str);
		if (str.length() < 2 || str.charAt(1) != ':')
			throw new IllegalArgumentException();
		char type = str.charAt(0);
		String rest = str.substring(2);
		switch (type) {
		case 'l':
			return KLinearGradientFill.decode(rest);
		case 'r':
			return KRadialGradientFill.decode(rest);
		}
		throw new IllegalArgumentException("unknown type " + type);
	}
}
