package jp.kitec.lib.util;

import java.io.Serializable;
import java.util.Vector;

/**
 * Vector2 クラスは、オブジェクトの可変長配列を実装する。
 * Java1.XではVectorがfinalな為直接派生できないことからJava2向けに修正
 *
 * @since 　2003/02/13
 * @author　Kawae
 * @version 2003/02/13
 * @version 2006/01/13 Vectorから派生させるよう変更
 * Copyright (c) 2002 KITec Inc,.. All rights reserved.
 */
public class Vector2<E> extends Vector<E> implements KCollection<E>, Serializable {


	/**
	 * 空の Vector2 を作成し、その内部データ配列のサイズが 10 で、
	 * その標準的な増分がゼロであるようにする。
	 *
	 * @since   2002/12/20
	 * @author  Kawae
	 * @version 2002/12/20
	 */
	public Vector2() {
		super();
	}

	/**
	 * 指定された初期容量、および増加量がゼロである、空の Vector2 を作成する。
	 *
	 * @since   2002/12/20
	 * @author  Kawae
	 * @version 2002/12/20
	 */
	public Vector2(int i) {
		super(i);
	}

	/**
	 * 指定されたインデックス位置の要素を返す。
	 * インデックスが、現在の要素数を越える場合、
	 * (インデックス - 要素数 * n) < 要素数
	 * となる最大の値が代替インデックスとして使用され、
	 * その位置の要素が返る。
	 * インデックスが、0 未満の場合、
	 * (インデックス + 要素数 * n) >= 0 となる最小の値が
	 * 代替インデックスとして使用され、その位置の要素が返る。
	 *
	 * @param c インデックス
	 * @return 指定されたインデックス位置にある要素。
	 * 			要素数が　0 の場合は、null
	 * @since   2002/12/20
	 * @author  Kawae
	 * @version 2002/12/20
	 */
	@Override
	public synchronized E elementAt(int i) {
		if (size() == 0)
			return null;
		if (i >= size())
			while (i >= size())
				i -= size();
		else if (i < 0)
			while (i < 0)
				i += size();
		return super.elementAt(i);
	}

	/**
	 * 指定されたインデックス位置の要素を返す。
	 * インデックスが、現在の要素数を越える場合、
	 * (インデックス - 要素数 * n) < 要素数
	 * となる最大の値が代替インデックスとして使用され、
	 * その位置の要素が返る。
	 * インデックスが、0 未満の場合、
	 * (インデックス + 要素数 * n) >= 0 となる最小の値が
	 * 代替インデックスとして使用され、その位置の要素が返る。
	 *
	 * @param c インデックス
	 * @return 指定されたインデックス位置にある要素。
	 * 			要素数が　0 の場合は、null
	 */
	@Override
	public synchronized E get(int index) {
		return elementAt(index);
	}

	/**
	 * この Vector2 の要素を共有する新たな Vector2 を構築し、返す。
	 *
	 * @return	要素を共有する新たな Vector2
	 * @since   2002/12/20
	 * @author  Kawae
	 * @version 2002/12/20
	 */
	public Vector2<E> getCopy() {
//		return (Vector2)this.clone();
		Vector2<E> v2 = new Vector2<E>(size());
		for (int i = 0; i < size(); i++)
			v2.addElement(elementAt(i));
		return v2;
	}
}