package jp.kitec.lib.util;


/**
 * 文字列の解析に対して、文字列のトークン区切り文字を
 * 使用できるトークン解析クラス。
 * 例）	区切り文字：xyz
 * 		解析文字列：aaxbccxyzdye
 * 		分割される文字列：
 * 					aaxbcc
 * 					dye
 *
 * @since 　2003/02/13
 * @author　Kawae
 * @version 2003/02/13
 *
 * Copyright (c) 2002 KITec Inc,.. All rights reserved.
 */
public class StringToken3 {

	/////////////////////////////////////////////////////////////////////////
	// フィールド

	/** 解析文字列 */
	private String str;
	/** 区切り文字列 */
	private String deli;

	/**
	 * 空の StringToken3 を作成する。
	 *
	 * @since   2003/02/13
	 * @author  Kawae
	 * @version 2003/02/13
	 */
	public StringToken3() {
	}


	/**
	 * 指定された文字列に対する StringToken3 を作成する。
	 * delim は、トークンを分ける区切り文字。区切り文字そのものは
	 * トークンとして扱われない。
	 *
	 * @param s	解析される文字列
	 * @param del	区切り文字
	 * @since   2003/02/13
	 * @author  Kawae
	 * @version 2003/02/13
	 */
	public  StringToken3(String s, String del) {
		str = s;
		setDelimitor(del);
	}

	/**
	 * 新たに解析する文字列を設定する。
	 *
	 * @param s	解析される文字列
	 * @since   2003/02/13
	 * @author  Kawae
	 * @version 2003/02/13
	 */
	public void setText(String s) {
		str = s;
	}

	/**
	 * 新たな区切り文字を設定する。
	 * 区切り文字そのものは、トークンとして扱われない。
	 *
	 * @param s	区切り文字
	 * @since   2003/02/13
	 * @author  Kawae
	 * @version 2003/02/13
	 * @throws NullPointerException 指定された区切り文字がnullの場合
	 * @throws IllegalArgumentException 指定された区切り文字の長さが0の場合
	 */
	public void setDelimitor(String s) {
		if (s == null)
			throw new NullPointerException();
		if (s.length() == 0)
			throw new IllegalArgumentException();
		deli = s;
	}

	/**
	 * トークナイザの文字列で利用できるトークンが
	 * まだあるかどうかを判定する。
	 *
	 * @return	文字列内の現在の位置の後ろに 1 つ以上の
	 * 			トークンがある場合だけ true、そうでない
	 * 			場合は false
	 * @since   2003/02/13
	 * @author  Kawae
	 * @version 2003/02/13
	 */
	public boolean hasMoreElements() {
		return str != null;
	}

	/**
	 * 文字列トークナイザから次のトークンを返す。
	 *
	 * @return	文字列トークナイザからの次のトークン
	 * @since   2003/02/13
	 * @author  Kawae
	 * @version 2003/02/13
	 */
	public String nextToken() {
		String res = null;
		if (str != null) {
			int tmp;
			if ((tmp = str.indexOf(deli)) >= 0) {
				res = str.substring(0, tmp);
				str = str.substring(tmp + deli.length());
			} else if (str.length() >= 0) {
				res = str;
				str = null;
			}
		}
		return res;
	}
}