package jp.kitec.kwt;

import java.io.Serializable;

import jp.kitec.lib.util.MathUtil;
import jp.kitec.lib.util.tree.ObjectFolder;
import jp.kitec.lib.util.tree.ObjectNode;

/**
 * 領域クラス
 * @author kawae
 *
 */
public class KArea implements Serializable {
	private static final long serialVersionUID = 1L;
	public static final String GEOMNAME = "AREA";

	public double minX, minY, maxX, maxY;

	public KArea() {
		maximize();
	}

	public KArea(double x1, double y1, double x2, double y2) {
		setArea(x1, y1, x2, y2);
	}

	public double getMinX() {
		return minX;
	}

	public void setMinX(double minX) {
		this.minX = minX;
	}

	public double getMinY() {
		return minY;
	}

	public void setMinY(double minY) {
		this.minY = minY;
	}

	public double getMaxX() {
		return maxX;
	}

	public void setMaxX(double maxX) {
		this.maxX = maxX;
	}

	public double getMaxY() {
		return maxY;
	}

	public void setMaxY(double maxY) {
		this.maxY = maxY;
	}

	public double width() {
		return maxX - minX;
	}

	public double height() {
		return maxY - minY;
	}

	public void maximize() {
		minX = minY = Double.POSITIVE_INFINITY;
		maxX = maxY = Double.NEGATIVE_INFINITY;
	}

	public void setArea(double x1, double y1, double x2, double y2) {
		maximize();
		updateMinMax(x1, y1);
		updateMinMax(x2, y2);
	}

	public void setArea(KArea a) {
		minX = a.minX;
		minY = a.minY;
		maxX = a.maxX;
		maxY = a.maxY;
	}

	public void updateMinMax(KArea a) {
		updateMinMax(a.minX, a.minY);
		updateMinMax(a.maxX, a.maxY);
	}

	public void updateMinMax(double x, double y) {
		minX = minX > x ? x : minX;
		minY = minY > y ? y : minY;
		maxX = maxX < x ? x : maxX;
		maxY = maxY < y ? y : maxY;
	}

	public void updateMinMaxX(double x) {
		minX = minX > x ? x : minX;
		maxX = maxX < x ? x : maxX;
	}

	public void updateMinMaxY(double y) {
		minY = minY > y ? y : minY;
		maxY = maxY < y ? y : maxY;
	}

	public boolean isInner(double x, double y) {
		return maxX >= x && x >= minX && maxY >= y && y >= minY;
	}

	public double distanceTo(double x, double y) {
		if (x < minX) {
			if (y < minY) {
				return MathUtil.getLength2D(minX, minY, x, y);
			} else if (y < maxY) {
				return minX - x;
			} else {
				return MathUtil.getLength2D(minX, maxY, x, y);
			}
		} else if(x < maxX) {
			if (y < minY) {
				return minY - y;
			} else if (y < maxY) {
				return 0;
			} else {
				return y - maxY;
			}
		} else {
			if (y < minY) {
				return MathUtil.getLength2D(maxX, minY, x, y);
			} else if (y < maxY) {
				return x - maxX;
			} else {
				return MathUtil.getLength2D(maxX, maxY, x, y);
			}
		}
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		long bits;
		bits = Double.doubleToLongBits(maxX);
		result = prime * result + (int)(bits ^ (bits >>> 32));
		bits = Double.doubleToLongBits(maxY);
		result = prime * result + (int)(bits ^ (bits >>> 32));
		bits = Double.doubleToLongBits(minX);
		result = prime * result + (int)(bits ^ (bits >>> 32));
		bits = Double.doubleToLongBits(minY);
		result = prime * result + (int)(bits ^ (bits >>> 32));
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		KArea other = (KArea) obj;
		if (Double.compare(minX, other.minX) != 0)
			return false;
		if (Double.compare(minY, other.minY) != 0)
			return false;
		if (Double.compare(maxX, other.maxX) != 0)
			return false;
		if (Double.compare(maxY, other.maxY) != 0)
			return false;
		return true;
	}

	public void save(ObjectFolder savenode) {
		savenode.setName(GEOMNAME);
		ObjectFolder.addNodeDouble(savenode, "minX", minX);
		ObjectFolder.addNodeDouble(savenode, "minY", minY);
		ObjectFolder.addNodeDouble(savenode, "maxX", maxX);
		ObjectFolder.addNodeDouble(savenode, "maxY", maxY);
	}

	public static void readData(ObjectFolder datanode, KArea a) {
		ObjectNode on;
		if ((on = datanode.getNode("minX")) != null)
			a.minX = on.getDouble(0);
		if ((on = datanode.getNode("minY")) != null)
			a.minY = on.getDouble(0);
		if ((on = datanode.getNode("maxX")) != null)
			a.maxX = on.getDouble(0);
		if ((on = datanode.getNode("maxY")) != null)
			a.maxY = on.getDouble(0);
	}
}
