package jp.kitec.lib.util.xml;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

import jp.kitec.lib.io.AbstFile;
import jp.kitec.lib.util.tree.ObjectFolder;



/**
 * XML 解析クラス。<BR>
 *
 * @since		2004/05/18
 * @author		fujita
 * @version	2004/05/18
 *
 * Copyright (c) 2004 KITec Inc,.. All rights reserved.
 */
public class XMLParser {

	/**
	 * 指定された in から XML データを読み込む。
	 *
	 * @param		in	XML データ入力オブジェクト
	 * @return		XML データを正しく読み込めた場合、
	 * 				そのデータを表す木構造オブジェクトtrue。
	 * 				そうでない場合は、null
	 * @since		2004/05/19
	 * @author		fujita
	 * @version	2004/05/19
	 * @throws IOException
	 */
	public ObjectFolder load(AbstFile in) throws IOException {
		ObjectFolder of = read(in, null);

		if (of == null) {
			return null;
		}

//		testPrintTree((ObjectFolder)of.getChildlen().elementAt(0), 0);

		return (ObjectFolder)of.getChildren().get(0);
	}

	public ObjectFolder load(AbstFile in, String encode) throws IOException {
		ObjectFolder of = read(in, encode);

		if (of == null) {
			return null;
		}

//		testPrintTree((ObjectFolder)of.getChildlen().elementAt(0), 0);

		return (ObjectFolder)of.getChildren().get(0);
	}


	/**
	 * 指定された in から XML データを読み込む。
	 *
	 * @param		in	XML データ入力ストリーム
	 * @return		XML データを正しく読み込めた場合、
	 * 				そのデータを表す木構造オブジェクトtrue。
	 * 				そうでない場合は、null
	 * @since		2004/05/19
	 * @author		fujita
	 * @version	2004/05/19
	 * @throws IOException
	 */
	public ObjectFolder load(InputStream in) throws IOException {
		ObjectFolder of = load(getInputFile(in));
		if (of == null) {
			return null;
		}

		return (ObjectFolder)of.getChildren().get(0);
	}

	/**
	 * 指定された file から XML データを読み込む。
	 *
	 * @param		file	XML データ入力ファイル（名）
	 * @return		XML データを正しく読み込めた場合、
	 * 				そのデータを表す木構造オブジェクトtrue。
	 * 				そうでない場合は、null
	 * @since		2004/05/19
	 * @author		fujita
	 * @version	2004/05/19
	 */
	public ObjectFolder load(String file) throws IOException {
		return load(getInputFile(file));
	}

	/**
	 * 指定された in をもとに、データ読み込みオブジェクトを作成する。
	 *
	 * @param		in	入力ストリーム
	 * @return		データ読み込みオブジェクト
	 * @since		2004/05/19
	 * @author		fujita
	 * @version	2004/05/19
	 */
	private AbstFile getInputFile(InputStream in) {
		if (in == null) return null;

		AbstFile af = new AbstFile();
		af.read(in, "");
		return af;
	}

	/**
	 * 指定された file をもとに、データ読み込みオブジェクトを作成する。
	 *
	 * @param		file	ファイル（名）
	 * @return		データ読み込みオブジェクト
	 * @since		2004/05/19
	 * @author		fujita
	 * @version	2004/05/19
	 */
	private AbstFile getInputFile(String file) {
		InputStream in = getInputStream(file);
		if (in == null) return null;

		AbstFile af = new AbstFile();
		af.read(in, file);
		return af;
	}

	/**
	 * 指定された file をもとに、入力ストリームを作成する。
	 *
	 * @param		file	ファイル（名）
	 * @return		入力ストリーム
	 * @since		2004/05/19
	 * @author		fujita
	 * @version	2004/05/19
	 */
	private InputStream getInputStream(String file) {
		try {
			return new FileInputStream(file);
		}
		catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}

	/**
	 * 指定された in から XML データを読み込む。
	 *
	 * @param		in	 XML データ入力オブジェクト
	 * @return		 XML データを正しく読み込めた場合、そのデータを持つ
	 * 				データオブジェクト。そうでない場合は、null
	 * @since		2004/05/19
	 * @author		fujita
	 * @version	2004/05/19
	 * @throws IOException
	 */
	private ObjectFolder read(AbstFile in, String encode) throws IOException {
		if (in == null) {
			return null;
		}

//		ObjectFolder of = XMLReader.readFile(af);
//		if (of.getChildlen().size() < 1) {
//			return null;
//		}

		XMLReader xml = new XMLReader(in);
		if (encode == null)
			return xml.read();
		else
			return xml.read(encode);
	}
}