package jp.kitec.kwt;

import java.io.Serializable;


public class KLinearGradientFill extends KGradientFill implements Serializable {
	private double mStartX, mStartY;
	private double mEndX, mEndY;

	public KLinearGradientFill(double startX, double startY, double endX, double endY,
			double[] fractions, KColor[] color) {
		super(color, fractions);
		mStartX = startX;
		mStartY = startY;
		mEndX = endX;
		mEndY = endY;
	}

	public double getStartX() {
		return mStartX;
	}

	public double getStartY() {
		return mStartY;
	}

	public double getEndX() {
		return mEndX;
	}

	public double getEndY() {
		return mEndY;
	}

	@Override
	public String encode() {
		StringBuilder sb = new StringBuilder(super.encode());
		sb.append(";");
		sb.append(mStartX);
		sb.append(";");
		sb.append(mStartY);
		sb.append(";");
		sb.append(mEndX);
		sb.append(";");
		sb.append(mEndY);
		return sb.toString();
	}
}