package jp.kitec.kwt;

public class KCursor {
	public static final KCursor CURSOR_DEF = new KCursor("DEFAULT_CURSOR");
	public static final KCursor CURSOR_VERT = new KCursor("N_RESIZE_CURSOR");
	public static final KCursor CURSOR_MOVE = new KCursor("MOVE_CURSOR");
	public static final KCursor CURSOR_HOR = new KCursor("W_RESIZE_CURSOR");
	public static final KCursor CURSOR_NE = new KCursor("NE_RESIZE_CURSOR");
	public static final KCursor CURSOR_NW = new KCursor("NW_RESIZE_CURSOR");
	public static final KCursor CURSOR_SW = new KCursor("SW_RESIZE_CURSOR");
	public static final KCursor CURSOR_SE = new KCursor("SE_RESIZE_CURSOR");
	public static final KCursor CURSOR_WAIT = new KCursor("WAIT_CURSOR");

	public static final KCursor CURSOR_HAND = new KCursor("HAND_CURSOR");

	private String name;

	/**
	 *
	 */
	public KCursor(String name) {
		this.name = name;
	}

	/**
	 * @return the name
	 */
	public String name() {
		return name;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((name == null) ? 0 : name.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		KCursor other = (KCursor) obj;
		if (name == null) {
			if (other.name != null)
				return false;
		} else if (!name.equals(other.name))
			return false;
		return true;
	}
}
