/*
 * Copyright (c) 2008 KITec Inc,.. All rights reserved.
 */
package jp.kitec.lib.util;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;



/**
 * 格納オブジェクトがnullでないことを保証する{@link Set}。
 *
 * @author $Author$
 * @version $Revision$ $Date::                           $
 */
public class SetNotNullDecorator<E> implements Set<E>, Serializable {

	private Set<E> mSet = null;

	public SetNotNullDecorator(Set<E> set) {
		super();
		this.mSet = set;
	}

	@Override
	public boolean add(E o) {
		if (o == null) return false;
		return this.mSet.add(o);
	}

	@Override
	public boolean addAll(Collection<? extends E> c) {
		boolean result = false;
		for (E element: c) {
			if (element == null) continue;
			this.mSet.add(element);
			result = true;
		}
		return result;
	}

	@Override
	public void clear() { this.mSet.clear(); }
	@Override
	public boolean contains(Object o) { return this.mSet.contains(o); }
	@Override
	public boolean containsAll(Collection<?> c) { return this.mSet.containsAll(c); }
	@Override
	public boolean equals(Object o) { return this.mSet.equals(o); }
	@Override
	public int hashCode() { return this.mSet.hashCode(); }
	@Override
	public boolean isEmpty() { return this.mSet.isEmpty(); }
	@Override
	public Iterator<E> iterator() { return this.mSet.iterator(); }
	@Override
	public boolean remove(Object o) { return this.mSet.remove(o); }
	@Override
	public boolean removeAll(Collection<?> c) { return this.mSet.removeAll(c); }
	@Override
	public boolean retainAll(Collection<?> c) { return this.mSet.retainAll(c); }
	@Override
	public int size() { return this.mSet.size(); }
	@Override
	public Object[] toArray() { return this.mSet.toArray(); }
	@Override
	public <T> T[] toArray(T[] a) { return this.mSet.toArray(a); }



} // end-interface
