package jp.kitec.lib.util;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang.ArrayUtils;



/**
 * 算術ユーティリティクラス
 *
 * @author $Author$
 * @version $Revision$ $Date::                           $
 */
public class ArithmeticUtil {

	//------------------------------------------------------------------
	//- constructors
	//------------------------------------------------------------------

	/**
	 * コンストラクタ
	 */
	protected ArithmeticUtil() {
	}



	//------------------------------------------------------------------
	//- methods
	//------------------------------------------------------------------

	/**
	 * 除算を行い、結果を配列で返す。<br/>
	 * 計算は、除算結果最大値を超えないように行われる。<br/>
	 * また、余りが出た場合、余りは最後の結果に加えられる。<br/>
	 *
	 * @param value 被除数
	 * @param divideMax 除算結果最大値
	 * @return 除算結果
	 */
	public static int[] divideToArray(int value, int divideMax) {
		List<Integer> result = new ArrayList<Integer>();

		int divideNum = (int)Math.floor(value / divideMax);
		divideNum += (value % divideMax == 0)? 0: 1;
		int divideValue = (int)Math.floor(value / divideNum);

		while (value >= divideValue) {
			value -= divideValue;
			if (value < divideValue) {
				divideValue += value;
				value = 0;
			}
			result.add(divideValue);
		}

		return ArrayUtils.toPrimitive(result.toArray(new Integer[result.size()]));
	}



} // end-class

